/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.auto.configuration;

import cool.doudou.doudada.oss.config.AliYunConfig;
import cool.doudou.doudada.oss.config.GridFsConfig;
import cool.doudou.doudada.oss.config.MinIOConfig;
import cool.doudou.doudada.oss.core.enums.StorageMode;
import cool.doudou.doudada.oss.core.helper.AliYunHelper;
import cool.doudou.doudada.oss.core.helper.GridFsHelper;
import cool.doudou.doudada.oss.core.helper.LocalHelper;
import cool.doudou.doudada.oss.core.helper.MinIOHelper;
import cool.doudou.doudada.oss.core.helper.OssHelper;
import cool.doudou.doudada.oss.properties.AliYunProperties;
import cool.doudou.doudada.oss.properties.GridFsProperties;
import cool.doudou.doudada.oss.properties.LocalProperties;
import cool.doudou.doudada.oss.properties.MinIoProperties;
import cool.doudou.doudada.oss.properties.OssProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(value={OssProperties.class, GridFsProperties.class, AliYunProperties.class, MinIoProperties.class, LocalProperties.class})
@Import(value={GridFsConfig.class, AliYunConfig.class, MinIOConfig.class})
@AutoConfiguration
public class OssAutoConfiguration {
    private OssProperties ossProperties;

    @ConditionalOnMissingBean(value={OssHelper.class})
    @Bean
    public OssHelper ossHelper() {
        switch (StorageMode.getByName(this.ossProperties.getStorageMode())) {
            case GRID_FS: {
                return new GridFsHelper();
            }
            case ALI_YUN: {
                return new AliYunHelper();
            }
            case MINIO: {
                return new MinIOHelper();
            }
        }
        return new LocalHelper();
    }

    @Autowired
    public void setOssProperties(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

