/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.config;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import cool.doudou.doudada.oss.properties.AliYunProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"oss.storage-mode"}, havingValue="aliYun")
public class AliYunConfig {
    private AliYunProperties aliYunProperties;

    @Bean
    public OSS ossClient() {
        OSS ossClient = new OSSClientBuilder().build(this.aliYunProperties.getEndpoint(), this.aliYunProperties.getAccessKeyId(), this.aliYunProperties.getAccessKeySecret());
        try {
            if (!ossClient.doesBucketExist(this.aliYunProperties.getBucketName())) {
                ossClient.createBucket(this.aliYunProperties.getBucketName());
            }
        }
        catch (ClientException | OSSException e) {
            e.printStackTrace();
        }
        return ossClient;
    }

    public AliYunConfig(AliYunProperties aliYunProperties) {
        this.aliYunProperties = aliYunProperties;
    }
}

