/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.config;

import cool.doudou.doudada.oss.properties.MinIoProperties;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"oss.storage-mode"}, havingValue="minIO")
public class MinIOConfig {
    private MinIoProperties minIoProperties;

    @Bean
    public MinioClient minioClient() {
        MinioClient minioClient = MinioClient.builder().endpoint(this.minIoProperties.getEndpoint()).credentials(this.minIoProperties.getAccessKey(), this.minIoProperties.getSecretKey()).build();
        try {
            if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.minIoProperties.getBucketName())).build())) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.minIoProperties.getBucketName())).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return minioClient;
    }

    public MinIOConfig(MinIoProperties minIoProperties) {
        this.minIoProperties = minIoProperties;
    }
}

