/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.core.helper;

import com.mongodb.BasicDBObject;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import cool.doudou.doudada.oss.core.helper.OssHelper;
import cool.doudou.doudada.oss.core.rs.OssResult;
import cool.doudou.doudada.oss.core.util.FileUtil;
import cool.doudou.doudada.oss.core.util.IoUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.multipart.MultipartFile;

@ConditionalOnProperty(name={"file.storage-mode"}, havingValue="gridFs")
public class GridFsHelper
implements OssHelper {
    private static final Logger log = LoggerFactory.getLogger(GridFsHelper.class);
    private GridFSBucket gridFsBucket;

    @Override
    public OssResult upload(MultipartFile multipartFile) {
        return this.upload(multipartFile, "default");
    }

    @Override
    public OssResult upload(File file) {
        return this.upload(file, "default");
    }

    @Override
    public OssResult upload(MultipartFile multipartFile, String category) {
        if (multipartFile == null) {
            throw new RuntimeException("\u6587\u4ef6\u5f02\u5e38");
        }
        String filename = multipartFile.getOriginalFilename();
        if (filename == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u5b57\u4e3a\u7a7a");
        }
        try {
            ObjectId objectId = this.gridFsBucket.uploadFromStream(filename, multipartFile.getInputStream(), new GridFSUploadOptions().metadata(new Document("category", (Object)category)));
            return OssResult.ok(objectId.toString(), filename, multipartFile.getContentType());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ", e);
        }
    }

    @Override
    public OssResult upload(File file, String category) {
        MultipartFile multipartFile;
        try {
            multipartFile = FileUtil.file2MultipartFile(file);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u5f02\u5e38");
        }
        return this.upload(multipartFile, category);
    }

    @Override
    public void download(String key, HttpServletResponse response) {
        this.download(key, "default", response);
    }

    @Override
    public void download(String key, String category, HttpServletResponse response) {
        try {
            this.check(key, category);
            IoUtil.setContentDisposition4Download(response, key);
            this.gridFsBucket.downloadToStream(new ObjectId(key), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 ", e);
        }
    }

    @Override
    public void preview(String key, HttpServletResponse response) {
        this.preview(key, "default", response);
    }

    @Override
    public void preview(String key, String category, HttpServletResponse response) {
        try {
            this.check(key, category);
            IoUtil.setContentDisposition4Preview(response, key);
            this.gridFsBucket.downloadToStream(new ObjectId(key), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u9884\u89c8\u5f02\u5e38 ", e);
        }
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, "default");
    }

    @Override
    public boolean delete(String key, String category) {
        try {
            this.check(key, category);
            this.gridFsBucket.delete(new ObjectId(key));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5220\u9664\u5f02\u5e38 ", e);
        }
    }

    public void check(String key, String category) throws Exception {
        GridFSFindIterable gridFsIterable = this.gridFsBucket.find((Bson)new BasicDBObject("_id", (Object)new ObjectId(key)).append("metadata.category", (Object)category));
        GridFSFile gridFsFile = (GridFSFile)gridFsIterable.first();
        if (gridFsFile == null) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + key);
        }
    }

    @Autowired
    public void setGridFsBucket(GridFSBucket gridFsBucket) {
        this.gridFsBucket = gridFsBucket;
    }
}

