/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.core.helper;

import cool.doudou.doudada.oss.core.helper.OssHelper;
import cool.doudou.doudada.oss.core.rs.OssResult;
import cool.doudou.doudada.oss.core.util.FileUtil;
import cool.doudou.doudada.oss.core.util.IoUtil;
import cool.doudou.doudada.oss.properties.LocalProperties;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.UrlResource;
import org.springframework.web.multipart.MultipartFile;

public class LocalHelper
implements OssHelper {
    private static final Logger log = LoggerFactory.getLogger(LocalHelper.class);
    private LocalProperties localProperties;

    @Override
    public OssResult upload(MultipartFile multipartFile) {
        return this.upload(multipartFile, "default");
    }

    @Override
    public OssResult upload(File file) {
        return this.upload(file, "default");
    }

    @Override
    public OssResult upload(MultipartFile multipartFile, String category) {
        if (multipartFile == null) {
            throw new RuntimeException("\u6587\u4ef6\u5f02\u5e38");
        }
        String filename = multipartFile.getOriginalFilename();
        if (filename == null) {
            throw new RuntimeException("\u6587\u4ef6\u540d\u79f0\u5f02\u5e38");
        }
        try {
            String key = FileUtil.getFileKey(filename, true);
            Path parentPath = Paths.get(this.localProperties.getPath(), category);
            if (Files.notExists(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            Path path = Files.createFile(parentPath.resolve(key), new FileAttribute[0]);
            Files.copy(multipartFile.getInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
            return OssResult.ok(key, filename, multipartFile.getContentType());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ", e);
        }
    }

    @Override
    public OssResult upload(File file, String category) {
        MultipartFile multipartFile;
        try {
            multipartFile = FileUtil.file2MultipartFile(file);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u5f02\u5e38");
        }
        return this.upload(multipartFile, category);
    }

    @Override
    public void download(String key, HttpServletResponse response) {
        this.download(key, "default", response);
    }

    @Override
    public void download(String key, String category, HttpServletResponse response) {
        try {
            Path path = this.check(key, category);
            UrlResource resource = new UrlResource(path.toUri());
            IoUtil.setContentDisposition4Download(response, key);
            IoUtil.write(resource.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", e);
        }
    }

    @Override
    public void preview(String key, HttpServletResponse response) {
        this.preview(key, "default", response);
    }

    @Override
    public void preview(String key, String category, HttpServletResponse response) {
        try {
            Path path = this.check(key, category);
            UrlResource resource = new UrlResource(path.toUri());
            IoUtil.setContentDisposition4Preview(response, key);
            IoUtil.write(resource.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u9884\u89c8\u5f02\u5e38", e);
        }
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, "default");
    }

    @Override
    public boolean delete(String key, String category) {
        try {
            Path path = this.check(key, category);
            return Files.deleteIfExists(path);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5220\u9664\u5f02\u5e38", e);
        }
    }

    public Path check(String key, String category) throws Exception {
        Path parentPath = Paths.get(this.localProperties.getPath(), category);
        if (Files.notExists(parentPath, new LinkOption[0])) {
            throw new RuntimeException("\u7236\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        Path path = parentPath.resolve(key);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return path;
    }

    @Autowired
    public void setLocalProperties(LocalProperties localProperties) {
        this.localProperties = localProperties;
    }
}

