/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUtil {
    public static String getFileKey(String filename, boolean hasSuffix) {
        Object key = UUID.randomUUID().toString().replaceAll("-", "");
        if (hasSuffix) {
            key = (String)key + filename.substring(filename.lastIndexOf("."));
        }
        return key;
    }

    public static MultipartFile file2MultipartFile(File file) {
        return new CommonsMultipartFile(FileUtil.createFileItem(file));
    }

    private static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem(file.getName(), "text/plain", true, file.getName());
        byte[] buffer = new byte[8192];
        try {
            int bytesRead;
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }
}

