/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.config;

import cool.doudou.doudada.pay.core.api.WxPayApi;
import cool.doudou.doudada.pay.core.api.ZfbPayApi;
import cool.doudou.doudada.pay.core.processor.WxNotifyBeanPostProcessor;
import cool.doudou.doudada.pay.core.processor.ZfbNotifyBeanPostProcessor;
import cool.doudou.doudada.pay.core.util.CertificateUtil;
import cool.doudou.doudada.pay.properties.WxPayProperties;
import cool.doudou.doudada.pay.properties.ZfbPayProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

public class PayConfig {
    private static final Logger log = LoggerFactory.getLogger(PayConfig.class);

    @Bean
    public WxPayApi wxPayApi() {
        return new WxPayApi();
    }

    @Bean
    public ZfbPayApi zfbPayApi() {
        return new ZfbPayApi();
    }

    @Bean
    public WxNotifyBeanPostProcessor wxNotifyBeanPostProcessor() {
        return new WxNotifyBeanPostProcessor();
    }

    @Bean
    public ZfbNotifyBeanPostProcessor zfbNotifyBeanPostProcessor() {
        return new ZfbNotifyBeanPostProcessor();
    }

    @Autowired
    public void init(WxPayProperties wxPayProperties, ZfbPayProperties zfbPayProperties, WxPayApi wxPayApi) {
        if (wxPayProperties.getEnabled().booleanValue()) {
            if (ObjectUtils.isEmpty((Object)wxPayProperties.getServerAddress()) || ObjectUtils.isEmpty((Object)wxPayProperties.getAppId()) || ObjectUtils.isEmpty((Object)wxPayProperties.getMchId()) || ObjectUtils.isEmpty((Object)wxPayProperties.getPrivateKeyPath()) || ObjectUtils.isEmpty((Object)wxPayProperties.getPrivateKeySerialNumber()) || ObjectUtils.isEmpty((Object)wxPayProperties.getApiKeyV3())) {
                throw new RuntimeException("\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
            }
            try {
                CertificateUtil.loadWxSecretKey(wxPayProperties.getPrivateKeyPath());
                wxPayApi.loadPlatformCertificate();
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u5fae\u4fe1\u5bc6\u94a5\u5f02\u5e38: ", (Throwable)e);
            }
        }
        if (zfbPayProperties.getEnabled().booleanValue()) {
            if (ObjectUtils.isEmpty((Object)zfbPayProperties.getServerAddress()) || ObjectUtils.isEmpty((Object)zfbPayProperties.getAppId()) || ObjectUtils.isEmpty((Object)zfbPayProperties.getPrivateKeyPath()) || ObjectUtils.isEmpty((Object)zfbPayProperties.getPublicKeyPath())) {
                throw new RuntimeException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u7f3a\u5931");
            }
            try {
                CertificateUtil.loadZfbSecretKey(zfbPayProperties.getPrivateKeyPath(), zfbPayProperties.getPublicKeyPath());
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u652f\u4ed8\u5b9d\u5bc6\u94a5\u5f02\u5e38: ", (Throwable)e);
            }
        }
    }
}

