/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.api;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import cool.doudou.doudada.pay.core.entity.PlaceOrderParam;
import cool.doudou.doudada.pay.core.entity.RefundParam;
import cool.doudou.doudada.pay.core.enums.ZfbTrade;
import cool.doudou.doudada.pay.core.util.HttpUtil;
import cool.doudou.doudada.pay.properties.ZfbPayProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class ZfbPayApi {
    private ZfbPayProperties zfbPayProperties;

    public Map<String, String> place(PlaceOrderParam placeOrderParam) {
        if (ObjectUtils.isEmpty((Object)placeOrderParam.getOutTradeNo())) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (placeOrderParam.getOutTradeNo().length() > 64) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u591a64\u4f4d");
        }
        if (!ObjectUtils.isEmpty((Object)placeOrderParam.getTimeExpire()) && placeOrderParam.getTimeExpire().length() != 19) {
            throw new RuntimeException("\u4ea4\u6613\u8d85\u65f6\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        JSONObject apiParamObj = new JSONObject();
        apiParamObj.put((Object)"out_trade_no", (Object)placeOrderParam.getOutTradeNo());
        apiParamObj.put((Object)"total_amount", (Object)placeOrderParam.getMoney());
        apiParamObj.put((Object)"subject", (Object)placeOrderParam.getDescription());
        if (!ObjectUtils.isEmpty((Object)placeOrderParam.getUid())) {
            apiParamObj.put((Object)"buyer_id", (Object)placeOrderParam.getUid());
        }
        if (!ObjectUtils.isEmpty((Object)placeOrderParam.getAttach())) {
            apiParamObj.put((Object)"body", (Object)placeOrderParam.getAttach());
        }
        if (!ObjectUtils.isEmpty((Object)placeOrderParam.getTimeExpire())) {
            apiParamObj.put((Object)"time_expire", (Object)placeOrderParam.getTimeExpire());
        }
        params.put("biz_content", apiParamObj.toJSONString(new JSONWriter.Feature[0]));
        String result = HttpUtil.doPost4Zfb(this.zfbPayProperties.getServerAddress(), ZfbTrade.TRADE_CREATE.method(), params, this.zfbPayProperties.getAppId(), this.zfbPayProperties.getNotifyUrl());
        if (ObjectUtils.isEmpty((Object)result)) {
            throw new RuntimeException("\u4e0b\u5355\u5931\u8d25");
        }
        JSONObject resultObj = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("outTradeNo", resultObj.getString("out_trade_no"));
        return map;
    }

    public String query(String outTradeNo) {
        if (ObjectUtils.isEmpty((Object)outTradeNo)) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        JSONObject apiParamObj = new JSONObject();
        apiParamObj.put((Object)"out_trade_no", (Object)outTradeNo);
        params.put("biz_content", apiParamObj.toJSONString(new JSONWriter.Feature[0]));
        return HttpUtil.doPost4Zfb(this.zfbPayProperties.getServerAddress(), ZfbTrade.TRADE_QUERY.method(), params, this.zfbPayProperties.getAppId(), this.zfbPayProperties.getNotifyUrl());
    }

    public String close(String outTradeNo) {
        if (ObjectUtils.isEmpty((Object)outTradeNo)) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        JSONObject apiParamObj = new JSONObject();
        apiParamObj.put((Object)"out_trade_no", (Object)outTradeNo);
        params.put("biz_content", apiParamObj.toJSONString(new JSONWriter.Feature[0]));
        return HttpUtil.doPost4Zfb(this.zfbPayProperties.getServerAddress(), ZfbTrade.TRADE_CLOSE.method(), params, this.zfbPayProperties.getAppId(), this.zfbPayProperties.getNotifyUrl());
    }

    public String refund(RefundParam refundParam) {
        if (ObjectUtils.isEmpty((Object)refundParam.getOutTradeNo())) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        JSONObject apiParamObj = new JSONObject();
        apiParamObj.put((Object)"out_trade_no", (Object)refundParam.getOutTradeNo());
        apiParamObj.put((Object)"refund_amount", (Object)refundParam.getRefundMoney());
        if (!ObjectUtils.isEmpty((Object)refundParam.getReason())) {
            apiParamObj.put((Object)"refund_reason", (Object)refundParam.getReason());
        }
        if (!ObjectUtils.isEmpty((Object)refundParam.getOutRefundNo())) {
            apiParamObj.put((Object)"out_request_no", (Object)refundParam.getOutRefundNo());
        }
        params.put("biz_content", apiParamObj.toJSONString(new JSONWriter.Feature[0]));
        return HttpUtil.doPost4Zfb(this.zfbPayProperties.getServerAddress(), ZfbTrade.TRADE_REFUND.method(), params, this.zfbPayProperties.getAppId(), this.zfbPayProperties.getNotifyUrl());
    }

    public String tradeBill(String billDate) {
        if (ObjectUtils.isEmpty((Object)billDate)) {
            throw new RuntimeException("\u8d26\u5355\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        JSONObject apiParamObj = new JSONObject();
        apiParamObj.put((Object)"bill_type", (Object)"trade");
        apiParamObj.put((Object)"bill_date", (Object)billDate);
        params.put("biz_content", apiParamObj.toJSONString(new JSONWriter.Feature[0]));
        return HttpUtil.doPost4Zfb(this.zfbPayProperties.getServerAddress(), ZfbTrade.TRADE_BILL_QUERY.method(), params, this.zfbPayProperties.getAppId(), this.zfbPayProperties.getNotifyUrl());
    }

    @Autowired
    public void setZfbPayProperties(ZfbPayProperties zfbPayProperties) {
        this.zfbPayProperties = zfbPayProperties;
    }
}

