/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.processor;

import cool.doudou.doudada.pay.annotation.WxPayNotify;
import cool.doudou.doudada.pay.core.enums.PayMode;
import cool.doudou.doudada.pay.core.factory.ConsumerMapFactory;
import cool.doudou.doudada.pay.core.method.NotifyMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WxNotifyBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(WxNotifyBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(WxPayNotify.class)).forEach(method -> {
            if (method.getReturnType() != Boolean.TYPE) {
                log.error("@WxPayNotify annotated method must return boolean, but is : {}", method.getReturnType());
                return;
            }
            ConsumerMapFactory.add(PayMode.WX, NotifyMethod.builder().bean(bean).method((Method)method).build());
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

