/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.util;

import cool.doudou.doudada.pay.core.memory.WxPayMem;
import cool.doudou.doudada.pay.core.memory.ZfbPayMem;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class CertificateUtil {
    public static void loadWxSecretKey(String privateFilePath) {
        try {
            WxPayMem.privateKey = CertificateUtil.loadPrivateKey(new FileInputStream(privateFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
    }

    public static void loadZfbSecretKey(String privateFilePath, String publicFilePath) {
        try {
            ZfbPayMem.privateKey = CertificateUtil.loadPrivateKey(new FileInputStream(privateFilePath));
            ZfbPayMem.publicKey = CertificateUtil.loadPublicKey(new FileInputStream(publicFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
    }

    public static PrivateKey loadPrivateKey(FileInputStream inputStream) {
        String privateKeyStr = CertificateUtil.loadFileContent(inputStream);
        try {
            privateKeyStr = privateKeyStr.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyStr)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bc6\u94a5\u5b57\u7b26\u4e32\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    private static PublicKey loadPublicKey(FileInputStream inputStream) {
        String publicKeyStr = CertificateUtil.loadFileContent(inputStream);
        try {
            publicKeyStr = publicKeyStr.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s+", "");
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bc6\u94a5\u5b57\u7b26\u4e32\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    private static String loadFileContent(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byte[] byteArr = new byte[1024];
        try {
            int readLength = inputStream.read(byteArr);
            while (readLength != -1) {
                byteArrayOutputStream.write(byteArr, 0, readLength);
                readLength = inputStream.read(byteArr);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bc6\u94a5\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", e);
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }
}

