package cool.doudou.doudada.pay.auto.configuration;

import cool.doudou.doudada.pay.config.PayConfig;
import cool.doudou.doudada.pay.core.helper.PayHelper;
import cool.doudou.doudada.pay.properties.WxPayProperties;
import cool.doudou.doudada.pay.properties.ZfbPayProperties;
import cool.doudou.doudada.pay.rest.service.PayNotifyService;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * PayAutoConfiguration
 *
 * @author jiangcs
 * @since 2022/2/19
 */
@EnableConfigurationProperties({WxPayProperties.class, ZfbPayProperties.class})
@Import({PayConfig.class})
@AutoConfiguration
public class PayAutoConfiguration {
    @ConditionalOnMissingBean(PayHelper.class)
    @Bean
    public PayHelper payHelper() {
        return new PayHelper();
    }

    @ConditionalOnMissingBean(PayNotifyService.class)
    @Bean
    public PayNotifyService payNotifyService() {
        return new PayNotifyService();
    }
}
