package cool.doudou.doudada.pay.core.factory;

import cool.doudou.doudada.pay.core.enums.PayMode;
import cool.doudou.doudada.pay.core.method.NotifyMethod;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * ConsumerMapFactory
 *
 * @author jiangcs
 * @since 2022/2/19
 */
public class ConsumerMapFactory {
    private static final Map<PayMode, NotifyMethod> map = new ConcurrentHashMap<>();

    public static NotifyMethod get(PayMode payMode) {
        return map.get(payMode);
    }

    public static void add(PayMode payMode, NotifyMethod notifyMethod) {
        map.put(payMode, notifyMethod);
    }
}
