package cool.doudou.doudada.pay.core.processor;

import cool.doudou.doudada.pay.annotation.ZfbPayNotify;
import cool.doudou.doudada.pay.core.enums.PayMode;
import cool.doudou.doudada.pay.core.factory.ConsumerMapFactory;
import cool.doudou.doudada.pay.core.method.NotifyMethod;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.util.Arrays;

/**
 * ZfbNotifyBeanPostProcessor
 *
 * @author jiangcs
 * @since 2022/2/20
 */
@Slf4j
public class ZfbNotifyBeanPostProcessor implements BeanPostProcessor {
    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getDeclaredMethods())
                .filter(method -> method.isAnnotationPresent(ZfbPayNotify.class))
                .forEach(method -> {
                    if (method.getReturnType() != boolean.class) {
                        log.error("@ZfbPayNotify annotated method must return boolean, but is : {}", method.getReturnType());
                        return;
                    }

                    ConsumerMapFactory.add(PayMode.ZFB, NotifyMethod.builder().bean(bean).method(method).build());
                });
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}
