/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.api;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import cool.doudou.doudada.cipher.algorithm.enums.Algorithm;
import cool.doudou.doudada.cipher.algorithm.util.AesUtil;
import cool.doudou.doudada.pay.core.entity.PlaceOrderParam;
import cool.doudou.doudada.pay.core.entity.RefundParam;
import cool.doudou.doudada.pay.core.memory.WxPayMem;
import cool.doudou.doudada.pay.core.signer.WxSigner;
import cool.doudou.doudada.pay.core.util.HttpUtil;
import cool.doudou.doudada.pay.properties.WxPayProperties;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class WxPayApi {
    private WxPayProperties wxPayProperties;

    public void loadPlatformCertificate() {
        String reqAbsoluteUrl = "/v3/certificates";
        String result = HttpUtil.doGet4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, null, this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
        if (!ObjectUtils.isEmpty((Object)result)) {
            JSONObject resultObj = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            JSONArray dataArr = resultObj.getJSONArray("data");
            int len = dataArr.size();
            for (int i = 0; i < len; ++i) {
                JSONObject dataObj = dataArr.getJSONObject(i);
                String serialNo = dataObj.getString("serial_no");
                JSONObject encryptCertificateObj = dataObj.getJSONObject("encrypt_certificate");
                String nonce = encryptCertificateObj.getString("nonce");
                String ciphertext = encryptCertificateObj.getString("ciphertext");
                String associatedData = encryptCertificateObj.getString("associated_data");
                try {
                    String decryptStr = AesUtil.decryptGCM((String)this.wxPayProperties.getApiKeyV3(), (String)nonce, (String)ciphertext, (String)associatedData);
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(decryptStr.getBytes(StandardCharsets.UTF_8)));
                    WxPayMem.certificateMap.put(serialNo, x509Certificate);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Map<String, String> place(PlaceOrderParam placeOrderParam) {
        if (ObjectUtils.isEmpty((Object)placeOrderParam.getOutTradeNo())) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (placeOrderParam.getOutTradeNo().length() < 6) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u957f\u5ea6\u4e0d\u80fd\u5c11\u4e8e6\u4f4d");
        }
        if (placeOrderParam.getOutTradeNo().length() > 32) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u957f\u5ea6\u4e0d\u80fd\u591a\u4e8e32\u4f4d");
        }
        if (!(ObjectUtils.isEmpty((Object)placeOrderParam.getTimeExpire()) || placeOrderParam.getTimeExpire().contains("T") && placeOrderParam.getTimeExpire().contains("+"))) {
            throw new RuntimeException("\u4ea4\u6613\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"appid", (Object)this.wxPayProperties.getAppId());
        jsonObject.put((Object)"mchid", (Object)this.wxPayProperties.getMchId());
        jsonObject.put((Object)"out_trade_no", (Object)placeOrderParam.getOutTradeNo());
        jsonObject.put((Object)"description", (Object)placeOrderParam.getDescription());
        if (!ObjectUtils.isEmpty((Object)placeOrderParam.getTimeExpire())) {
            jsonObject.put((Object)"time_expire", (Object)placeOrderParam.getTimeExpire());
        }
        if (!ObjectUtils.isEmpty((Object)placeOrderParam.getAttach())) {
            jsonObject.put((Object)"attach", (Object)placeOrderParam.getAttach());
        }
        jsonObject.put((Object)"notify_url", (Object)this.wxPayProperties.getNotifyUrl());
        JSONObject jsonAmount = new JSONObject();
        jsonAmount.put((Object)"total", (Object)placeOrderParam.getMoney().intValue());
        jsonAmount.put((Object)"currency", (Object)"CNY");
        jsonObject.put((Object)"amount", (Object)jsonAmount);
        JSONObject jsonPayer = new JSONObject();
        jsonPayer.put((Object)"openid", (Object)placeOrderParam.getUid());
        jsonObject.put((Object)"payer", (Object)jsonPayer);
        String reqAbsoluteUrl = "/v3/pay/transactions/jsapi";
        String result = HttpUtil.doPost4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, jsonObject.toJSONString(new JSONWriter.Feature[0]), this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
        if (ObjectUtils.isEmpty((Object)result)) {
            throw new RuntimeException("\u4e0b\u5355\u5931\u8d25");
        }
        JSONObject resultObj = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = UUID.randomUUID().toString();
        String packageStr = "prepay_id=" + resultObj.getString("prepay_id");
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("timestamp", timestamp);
        map.put("nonceStr", nonceStr);
        map.put("package", packageStr);
        map.put("signType", Algorithm.RSA.code());
        map.put("paySign", WxSigner.getPayment(this.wxPayProperties.getAppId(), timestamp, nonceStr, packageStr));
        return map;
    }

    public String query(String outTradeNo) {
        if (ObjectUtils.isEmpty((Object)outTradeNo)) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("mchid", this.wxPayProperties.getMchId());
        String reqAbsoluteUrl = "/v3/pay/transactions/out-trade-no/" + outTradeNo;
        return HttpUtil.doGet4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, params, this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
    }

    public String close(String outTradeNo) {
        if (ObjectUtils.isEmpty((Object)outTradeNo)) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"mchid", (Object)this.wxPayProperties.getMchId());
        String reqAbsoluteUrl = "/v3/pay/transactions/out-trade-no/" + outTradeNo + "/close";
        boolean flag = HttpUtil.doPostNoContent4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, jsonObject.toJSONString(new JSONWriter.Feature[0]), this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
        if (flag) {
            return JSONObject.of((String)"code", (Object)"ok").toString();
        }
        return JSONObject.of((String)"code", (Object)"fail").toString();
    }

    public String refund(RefundParam refundParam) {
        if (ObjectUtils.isEmpty((Object)refundParam.getOutTradeNo())) {
            throw new RuntimeException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"out_trade_no", (Object)refundParam.getOutTradeNo());
        jsonObject.put((Object)"out_refund_no", (Object)refundParam.getOutRefundNo());
        jsonObject.put((Object)"reason", (Object)refundParam.getReason());
        JSONObject jsonAmount = new JSONObject();
        jsonAmount.put((Object)"total", (Object)refundParam.getMoney());
        jsonAmount.put((Object)"currency", (Object)"CNY");
        jsonAmount.put((Object)"refund", (Object)refundParam.getRefundMoney());
        jsonObject.put((Object)"amount", (Object)jsonAmount);
        String reqAbsoluteUrl = "/v3/refund/domestic/refunds";
        return HttpUtil.doPost4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, jsonObject.toJSONString(new JSONWriter.Feature[0]), this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
    }

    public String tradeBill(String billDate) {
        if (ObjectUtils.isEmpty((Object)billDate)) {
            throw new RuntimeException("\u8d26\u5355\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("bill_date", billDate);
        String reqAbsoluteUrl = "/v3/bill/tradebill";
        return HttpUtil.doGet4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, params, this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
    }

    public ByteArrayInputStream downloadBill(String billUrl) {
        String[] billUrlArr = billUrl.split("\\?");
        if (billUrlArr.length != 2) {
            throw new RuntimeException("\u8d26\u5355\u5730\u5740\u683c\u5f0f\u9519\u8bef");
        }
        String reqAbsoluteUrl = billUrlArr[0].replace(this.wxPayProperties.getServerAddress(), "");
        String[] paramArr = billUrlArr[1].split("=");
        if (paramArr.length != 2) {
            throw new RuntimeException("\u8d26\u5355\u5730\u5740\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put(paramArr[0], paramArr[1]);
        return HttpUtil.doGetInputStream4Wx(this.wxPayProperties.getServerAddress(), reqAbsoluteUrl, params, this.wxPayProperties.getMchId(), this.wxPayProperties.getPrivateKeySerialNumber());
    }

    @Autowired
    public void setWxPayProperties(WxPayProperties wxPayProperties) {
        this.wxPayProperties = wxPayProperties;
    }
}

