/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.signer;

import cool.doudou.doudada.cipher.algorithm.enums.SignAlgorithm;
import cool.doudou.doudada.cipher.algorithm.util.SignatureUtil;
import cool.doudou.doudada.pay.core.memory.WxPayMem;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;

public class WxSigner {
    public static String getAuthorization(String mchId, String privateKeySerialNumber, String reqMethod, String reqAbsoluteUrl, Map<String, Object> reqParam, String reqBody) {
        String schema = "WECHATPAY2-SHA256-RSA2048";
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString().replaceAll("-", "");
        StringBuilder sbUrlParam = new StringBuilder();
        if (reqParam != null) {
            for (String key : reqParam.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(reqParam.get(key));
            }
        }
        reqAbsoluteUrl = (String)reqAbsoluteUrl + sbUrlParam;
        String signatureStr = reqMethod + "\n" + (String)reqAbsoluteUrl + "\n" + timestamp + "\n" + nonceStr + "\n" + reqBody + "\n";
        String signatureValue = WxSigner.computeSignatureValue(signatureStr);
        String signatureInfo = "mchid=\"" + mchId + "\",serial_no=\"" + privateKeySerialNumber + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",signature=\"" + signatureValue + "\"";
        return schema + " " + signatureInfo;
    }

    public static String getPayment(String appId, String timestamp, String nonceStr, String packageStr) {
        String signatureStr = appId + "\n" + timestamp + "\n" + nonceStr + "\n" + packageStr + "\n";
        return WxSigner.computeSignatureValue(signatureStr);
    }

    private static String computeSignatureValue(String signatureStr) {
        byte[] encryptArr = SignatureUtil.sign((SignAlgorithm)SignAlgorithm.SHA256withRSA, (String)signatureStr, (PrivateKey)WxPayMem.privateKey);
        return Base64.getEncoder().encodeToString(encryptArr);
    }

    public static boolean verify(X509Certificate certificate, String timestamp, String nonceStr, String jsonStr, String signatureStr) {
        try {
            String sbSignatureValue = timestamp + "\n" + nonceStr + "\n" + jsonStr + "\n";
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(certificate);
            signature.update(sbSignatureValue.getBytes(StandardCharsets.UTF_8));
            return signature.verify(Base64.getDecoder().decode(signatureStr));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bc1\u4e66\u9a8c\u8bc1\u5f02\u5e38", e);
        }
    }
}

