/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.signer;

import cool.doudou.doudada.cipher.algorithm.enums.SignAlgorithm;
import cool.doudou.doudada.cipher.algorithm.util.SignatureUtil;
import cool.doudou.doudada.pay.core.memory.ZfbPayMem;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ZfbSigner {
    public static String get(Map<String, String> publicParamMap, Map<String, String> bizParamMap) {
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.putAll(publicParamMap);
        paramMap.putAll(bizParamMap);
        ArrayList<String> keyList = new ArrayList<String>(paramMap.keySet());
        Collections.sort(keyList);
        return ZfbSigner.computeSignatureValue(keyList, paramMap);
    }

    private static String computeSignatureValue(List<String> keyList, Map<String, String> paramMap) {
        StringBuilder sbSignatureValue = new StringBuilder();
        for (String key : keyList) {
            if (sbSignatureValue.length() > 0) {
                sbSignatureValue.append("&");
            }
            sbSignatureValue.append(key).append("=").append(paramMap.get(key));
        }
        byte[] encryptArr = SignatureUtil.sign((SignAlgorithm)SignAlgorithm.SHA256withRSA, (String)sbSignatureValue.toString(), (PrivateKey)ZfbPayMem.privateKey);
        return Base64.getEncoder().encodeToString(encryptArr);
    }

    public static boolean verify(Map<String, String[]> paramMap, String signatureStr) {
        paramMap.forEach((key, value) -> URLDecoder.decode(value[0], StandardCharsets.UTF_8));
        ArrayList<String> keyList = new ArrayList<String>(paramMap.keySet());
        Collections.sort(keyList);
        StringBuilder sbSignatureValue = new StringBuilder();
        for (String key2 : keyList) {
            if (sbSignatureValue.length() > 0) {
                sbSignatureValue.append("&");
            }
            sbSignatureValue.append(key2).append("=").append(paramMap.get(key2)[0]);
        }
        return SignatureUtil.verify((SignAlgorithm)SignAlgorithm.SHA256withRSA, (String)sbSignatureValue.toString(), (PublicKey)ZfbPayMem.publicKey, (String)signatureStr);
    }
}

