/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.core.util;

import cool.doudou.doudada.pay.core.factory.OkHttpFactory;
import cool.doudou.doudada.pay.core.signer.WxSigner;
import cool.doudou.doudada.pay.core.signer.ZfbSigner;
import cool.doudou.doudada.pay.core.util.DateUtil;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final OkHttpClient okHttpClient = OkHttpFactory.get();

    public static String doGet4Wx(String serverAddress, String reqAbsoluteUrl, Map<String, Object> params, String mchId, String privateKeySerialNumber) {
        String url = serverAddress + reqAbsoluteUrl;
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("Accept", "application/json");
        builder.addHeader("Authorization", WxSigner.getAuthorization(mchId, privateKeySerialNumber, "GET", reqAbsoluteUrl, params, ""));
        StringBuilder sbUrlParam = new StringBuilder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(params.get(key));
            }
        }
        url = url + sbUrlParam;
        Request request = builder.url(url).build();
        log.info("[wx] url => GET {}", (Object)url);
        log.info("[wx] authorization => {}", (Object)request.header("Authorization"));
        log.info("[wx] params => {}", params);
        return HttpUtil.execute(request);
    }

    public static ByteArrayInputStream doGetInputStream4Wx(String serverAddress, String reqAbsoluteUrl, Map<String, Object> params, String mchId, String privateKeySerialNumber) {
        String url = serverAddress + reqAbsoluteUrl;
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("Accept", "application/json");
        builder.addHeader("Authorization", WxSigner.getAuthorization(mchId, privateKeySerialNumber, "GET", reqAbsoluteUrl, params, ""));
        StringBuilder sbUrlParam = new StringBuilder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(params.get(key));
            }
        }
        url = url + sbUrlParam;
        Request request = builder.url(url).build();
        log.info("[wx] url => GET {}", (Object)url);
        log.info("[wx] authorization => {}", (Object)request.header("Authorization"));
        log.info("[wx] params => {}", params);
        return HttpUtil.executeInputStream(request);
    }

    public static boolean doPostNoContent4Wx(String serverAddress, String reqAbsoluteUrl, String jsonBody, String mchId, String certificateSerialNumber) {
        String url = serverAddress + reqAbsoluteUrl;
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("Accept", "application/json");
        builder.addHeader("Authorization", WxSigner.getAuthorization(mchId, certificateSerialNumber, "POST", reqAbsoluteUrl, null, jsonBody));
        if (jsonBody == null) {
            jsonBody = "";
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody);
        Request request = builder.url(url).post(requestBody).build();
        log.info("[wx] url => POST {}", (Object)url);
        log.info("[wx] authorization => {}", (Object)request.header("Authorization"));
        log.info("[wx] body => {}", (Object)jsonBody);
        return HttpUtil.executeNoContent(request);
    }

    public static String doPost4Wx(String serverAddress, String reqAbsoluteUrl, String jsonBody, String mchId, String certificateSerialNumber) {
        String url = serverAddress + reqAbsoluteUrl;
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("Accept", "application/json");
        builder.addHeader("Authorization", WxSigner.getAuthorization(mchId, certificateSerialNumber, "POST", reqAbsoluteUrl, null, jsonBody));
        if (jsonBody == null) {
            jsonBody = "";
        }
        RequestBody requestBody = RequestBody.create((String)jsonBody, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = builder.url(url).post(requestBody).build();
        log.info("[wx] url => POST {}", (Object)url);
        log.info("[wx] authorization => {}", (Object)request.header("Authorization"));
        log.info("[wx] body => {}", (Object)jsonBody);
        return HttpUtil.execute(request);
    }

    public static String doPost4Zfb(String url, String method, Map<String, String> params, String appId, String notifyUrl) {
        HashMap<String, String> publicParamMap = new HashMap<String, String>(8);
        publicParamMap.put("app_id", appId);
        publicParamMap.put("method", method);
        publicParamMap.put("charset", "utf-8");
        publicParamMap.put("sign_type", "RSA2");
        publicParamMap.put("timestamp", DateUtil.formatDate(new Date()));
        publicParamMap.put("version", "1.0");
        publicParamMap.put("notify_url", notifyUrl);
        publicParamMap.put("sign", ZfbSigner.get(publicParamMap, params));
        Request.Builder builder = new Request.Builder();
        StringBuilder sbPublicParam = new StringBuilder();
        for (Object key : publicParamMap.keySet()) {
            if (sbPublicParam.length() <= 0) {
                sbPublicParam.append("?");
            } else {
                sbPublicParam.append("&");
            }
            sbPublicParam.append((String)key).append("=").append(URLEncoder.encode((String)publicParamMap.get(key), StandardCharsets.UTF_8));
        }
        url = (String)url + sbPublicParam;
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                formBuilder.add(key, params.get(key));
            }
        }
        FormBody requestBody = formBuilder.build();
        Request request = builder.url((String)url).post((RequestBody)requestBody).build();
        log.info("[zfb] url => POST {}", url);
        log.info("[zfb] method => {}", (Object)method);
        log.info("[zfb] params => {}", params);
        return HttpUtil.execute(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String execute(Request request) {
        try (Response response = okHttpClient.newCall(request).execute();){
            ResponseBody responseBody;
            if (response.isSuccessful() && !ObjectUtils.isEmpty((Object)(responseBody = response.body()))) {
                String result = responseBody.string();
                log.info("execute => success: {}", (Object)result);
                String string = result;
                return string;
            }
            log.error("execute => fail: {}", (Object)response);
            return null;
        }
        catch (Exception e) {
            log.error("execute => exception: ", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean executeNoContent(Request request) {
        try (Response response = okHttpClient.newCall(request).execute();){
            if (response.isSuccessful() && response.code() == HttpStatus.NO_CONTENT.value()) {
                boolean bl = true;
                return bl;
            }
            log.error("execute => fail: {}", (Object)response);
            return false;
        }
        catch (Exception e) {
            log.error("execute => exception: ", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ByteArrayInputStream executeInputStream(Request request) {
        try (Response response = okHttpClient.newCall(request).execute();){
            ResponseBody responseBody;
            if (response.isSuccessful() && !ObjectUtils.isEmpty((Object)(responseBody = response.body()))) {
                log.info("execute => success: {}[{}]", (Object)responseBody.contentType(), (Object)responseBody.contentLength());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseBody.bytes());
                return byteArrayInputStream;
            }
            log.error("execute => fail: {}", (Object)response);
            return null;
        }
        catch (Exception e) {
            log.error("execute => exception: ", (Throwable)e);
        }
        return null;
    }
}

