/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.pay.rest.service;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import cool.doudou.doudada.cipher.algorithm.util.AesUtil;
import cool.doudou.doudada.pay.core.enums.PayMode;
import cool.doudou.doudada.pay.core.factory.ConsumerMapFactory;
import cool.doudou.doudada.pay.core.memory.WxPayMem;
import cool.doudou.doudada.pay.core.method.NotifyMethod;
import cool.doudou.doudada.pay.core.signer.WxSigner;
import cool.doudou.doudada.pay.core.signer.ZfbSigner;
import cool.doudou.doudada.pay.core.util.RespUtil;
import cool.doudou.doudada.pay.properties.WxPayProperties;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PayNotifyService {
    private static final Logger log = LoggerFactory.getLogger(PayNotifyService.class);
    private WxPayProperties wxPayProperties;

    public void wx(String jsonStr, HttpServletRequest request, HttpServletResponse response) {
        try {
            String timestamp = request.getHeader("Wechatpay-Timestamp");
            String nonceStr = request.getHeader("Wechatpay-Nonce");
            String signatureStr = request.getHeader("Wechatpay-Signature");
            String serial = request.getHeader("Wechatpay-Serial");
            X509Certificate x509Certificate = WxPayMem.certificateMap.get(serial);
            boolean verifyFlag = WxSigner.verify(x509Certificate, timestamp, nonceStr, jsonStr, signatureStr);
            if (!verifyFlag) {
                throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
            JSONObject bodyObj = (JSONObject)JSONObject.parseObject((String)jsonStr, JSONObject.class);
            JSONObject resourceObj = bodyObj.getJSONObject("resource");
            String nonce = resourceObj.getString("nonce");
            String ciphertext = resourceObj.getString("ciphertext");
            String associatedData = resourceObj.getString("associated_data");
            String decryptStr = AesUtil.decryptGCM((String)this.wxPayProperties.getApiKeyV3(), (String)nonce, (String)ciphertext, (String)associatedData);
            NotifyMethod notifyMethod = ConsumerMapFactory.get(PayMode.WX);
            if (notifyMethod != null) {
                Object bean = notifyMethod.getBean();
                Method method = notifyMethod.getMethod();
                try {
                    method.setAccessible(true);
                    Boolean respFlag = (Boolean)method.invoke(bean, decryptStr);
                    if (respFlag.booleanValue()) {
                        RespUtil.writeSuccess(response, "");
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("bean[{}].method[{}] invoke exception: ", new Object[]{bean, method.getName(), e});
                }
                throw new RuntimeException("\u4e1a\u52a1\u65b9\u6cd5\u5904\u7406\u5f02\u5e38");
            }
            log.warn("No NotifyMethod found");
            RespUtil.writeSuccess(response, "");
        }
        catch (Exception e) {
            log.error("wxPay exception: ", (Throwable)e);
            JSONObject resultObj = new JSONObject();
            resultObj.put((Object)"code", (Object)"FAIL");
            resultObj.put((Object)"message", (Object)e.getMessage());
            RespUtil.writeFail(response, resultObj.toJSONString(new JSONWriter.Feature[0]));
        }
    }

    public void zfb(HttpServletRequest request, HttpServletResponse response) {
        try {
            Map paramMap = request.getParameterMap();
            String signatureStr = new String(Base64.getDecoder().decode(((String[])paramMap.remove("sign"))[0]));
            paramMap.remove("sign_type");
            boolean verifyFlag = ZfbSigner.verify(paramMap, signatureStr);
            if (!verifyFlag) {
                throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
            JSONObject jsonObject = new JSONObject();
            paramMap.keySet().forEach(key -> jsonObject.put(key, (Object)((String[])paramMap.get(key))[0]));
            NotifyMethod notifyMethod = ConsumerMapFactory.get(PayMode.ZFB);
            if (notifyMethod != null) {
                Object bean = notifyMethod.getBean();
                Method method = notifyMethod.getMethod();
                try {
                    method.setAccessible(true);
                    Boolean respFlag = (Boolean)method.invoke(bean, jsonObject.toString());
                    if (respFlag.booleanValue()) {
                        RespUtil.writeSuccess(response, "success");
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("bean[{}].method[{}] invoke exception: ", new Object[]{bean, method.getName(), e});
                }
                throw new RuntimeException("\u4e1a\u52a1\u65b9\u6cd5\u5904\u7406\u5f02\u5e38");
            }
            log.warn("No NotifyMethod found");
            RespUtil.writeSuccess(response, "success");
        }
        catch (Exception e) {
            log.error("zfbPay exception: ", (Throwable)e);
            RespUtil.writeFail(response, "fail");
        }
    }

    @Autowired
    public void setPayWxProperties(WxPayProperties wxPayProperties) {
        this.wxPayProperties = wxPayProperties;
    }
}

