/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.config;

import cool.doudou.doudada.wechat.core.api.WechatApi;
import cool.doudou.doudada.wechat.core.processor.WechatNotifyBeanPostProcessor;
import cool.doudou.doudada.wechat.core.processor.WechatOAuth2BeanPostProcessor;
import cool.doudou.doudada.wechat.core.util.ThreadPoolUtil;
import cool.doudou.doudada.wechat.properties.WechatProperties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

public class WechatConfig {
    private static final Logger log = LoggerFactory.getLogger(WechatConfig.class);

    @Bean
    public WechatNotifyBeanPostProcessor wechatNotifyBeanPostProcessor() {
        return new WechatNotifyBeanPostProcessor();
    }

    @Bean
    public WechatOAuth2BeanPostProcessor wechatOauth2BeanPostProcessor() {
        return new WechatOAuth2BeanPostProcessor();
    }

    @Autowired
    public void init(WechatProperties wechatProperties) {
        if (ObjectUtils.isEmpty(wechatProperties.getCredentials())) {
            throw new RuntimeException("\u5fae\u4fe1\u51ed\u8bc1\u4fe1\u606f\u672a\u914d\u7f6e");
        }
        try {
            ThreadPoolUtil.getScheduledInstance().scheduleAtFixedRate(() -> wechatProperties.getCredentials().forEach(credential -> {
                WechatApi.accessToken(credential.getAppId(), credential.getSecret());
                WechatApi.jsApiTicket(credential.getAppId());
            }), 5L, 7000L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1Token\u83b7\u53d6\u5f02\u5e38: ", (Throwable)e);
        }
    }
}

