/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.core.api;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import cool.doudou.doudada.wechat.core.factory.TokenMapFactory;
import cool.doudou.doudada.wechat.core.util.HttpUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class WechatApi {
    private static final Logger log = LoggerFactory.getLogger(WechatApi.class);

    public static void accessToken(String appId, String secret) {
        String url = "https://api.weixin.qq.com/cgi-bin/token";
        try {
            HashMap<String, Object> urlParam = new HashMap<String, Object>(3);
            urlParam.put("grant_type", "client_credential");
            urlParam.put("appid", appId);
            urlParam.put("secret", secret);
            String result = HttpUtil.doGet(url, urlParam);
            if (!ObjectUtils.isEmpty((Object)result)) {
                JSONObject accessTokenObj = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
                if (accessTokenObj != null) {
                    if (ObjectUtils.isEmpty((Object)accessTokenObj.getString("errcode"))) {
                        String accessToken = accessTokenObj.getString("access_token");
                        if (!ObjectUtils.isEmpty((Object)accessToken)) {
                            TokenMapFactory.set("access_token_" + appId, accessToken);
                            return;
                        }
                        throw new RuntimeException("accessToken is empty");
                    }
                    throw new RuntimeException("accessTokenObj error: " + accessTokenObj.toJSONString(new JSONWriter.Feature[0]));
                }
                throw new RuntimeException("accessTokenObj is empty or ");
            }
            throw new RuntimeException("result is empty");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[cgi-bin/token]\u5f02\u5e38: appId[{}] => ", (Object)appId, (Object)e);
            return;
        }
    }

    public static void jsApiTicket(String appId) {
        String accessToken = TokenMapFactory.get("access_token_" + appId);
        if (ObjectUtils.isEmpty((Object)accessToken)) {
            throw new RuntimeException("accessToken is empty");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
        try {
            HashMap<String, Object> urlParam = new HashMap<String, Object>(2);
            urlParam.put("type", "jsapi");
            urlParam.put("access_token", accessToken);
            String result = HttpUtil.doGet(url, urlParam);
            if (!ObjectUtils.isEmpty((Object)result)) {
                JSONObject jsonTicketObj = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
                if (jsonTicketObj != null) {
                    if (0 == jsonTicketObj.getIntValue("errcode")) {
                        String ticket = jsonTicketObj.getString("ticket");
                        if (!ObjectUtils.isEmpty((Object)ticket)) {
                            TokenMapFactory.set("js_api_ticket_" + appId, ticket);
                            return;
                        }
                        throw new RuntimeException("ticket is empty");
                    }
                    throw new RuntimeException("jsonTicketObj error: " + jsonTicketObj.toJSONString(new JSONWriter.Feature[0]));
                }
                throw new RuntimeException("jsonTicketObj is empty");
            }
            throw new RuntimeException("result is empty.");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[cgi-bin/ticket/getticket]\u5f02\u5e38: appId[{}] => ", (Object)appId, (Object)e);
            return;
        }
    }

    public static JSONObject oauth2Token(String appId, String secret, String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token";
        try {
            HashMap<String, Object> urlParam = new HashMap<String, Object>(4);
            urlParam.put("appid", appId);
            urlParam.put("secret", secret);
            urlParam.put("code", code);
            urlParam.put("grant_type", "authorization_code");
            String result = HttpUtil.doGet(url, urlParam);
            if (!ObjectUtils.isEmpty((Object)result)) {
                return (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            }
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[sns/oauth2/access_token]\u5931\u8d25\uff1aresult is empty.");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[sns/oauth2/access_token]\u5f02\u5e38.", (Throwable)e);
        }
        return null;
    }

    public static JSONObject getUserInfo(String openId, String accessToken) {
        String url = "https://api.weixin.qq.com/sns/userinfo";
        try {
            HashMap<String, Object> urlParam = new HashMap<String, Object>(3);
            urlParam.put("access_token", accessToken);
            urlParam.put("openid", openId);
            urlParam.put("lang", "zh_CN");
            String result = HttpUtil.doGet(url, urlParam);
            if (!ObjectUtils.isEmpty((Object)result)) {
                return (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            }
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[cgi-bin/user/info]\u5931\u8d25\uff1a{} => result is empty", (Object)openId);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[cgi-bin/user/info]\u5f02\u5e38\uff1a{}", (Object)openId, (Object)e);
        }
        return null;
    }

    public static JSONObject getMenu(String appId) {
        String url = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info";
        try {
            HashMap<String, Object> urlParam = new HashMap<String, Object>(1);
            urlParam.put("access_token", TokenMapFactory.get("access_token_" + appId));
            String result = HttpUtil.doGet(url, urlParam);
            if (!ObjectUtils.isEmpty((Object)result)) {
                return (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            }
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[cgi-bin/get_current_selfmenu_info]\u5931\u8d25\uff1aresult is empty");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[cgi-bin/get_current_selfmenu_info]\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public static JSONObject createMenu(String appId, String jsonStr) {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
        HashMap<String, Object> urlParam = new HashMap<String, Object>(1);
        urlParam.put("access_token", TokenMapFactory.get("access_token_" + appId));
        try {
            String result = HttpUtil.doPost(url, urlParam, jsonStr);
            if (!ObjectUtils.isEmpty((Object)result)) {
                return (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            }
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[menu/create]\u5931\u8d25: {} => result is empty", (Object)jsonStr);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[menu/create]\u5931\u8d25: {}", (Object)jsonStr, (Object)e);
        }
        return null;
    }

    public static JSONObject deleteMenu(String appId) {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete";
        HashMap<String, Object> urlParam = new HashMap<String, Object>(1);
        urlParam.put("access_token", TokenMapFactory.get("access_token_" + appId));
        try {
            String result = HttpUtil.doGet(url, urlParam);
            if (!ObjectUtils.isEmpty((Object)result)) {
                return (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            }
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[menu/delete]\u5931\u8d25\uff1aresult is empty");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3[menu/delete]\u5f02\u5e38.", (Throwable)e);
        }
        return null;
    }
}

