/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.core.helper;

import cool.doudou.doudada.wechat.core.entity.xml.msg.ImgTextArticle;
import cool.doudou.doudada.wechat.core.entity.xml.msg.ImgTextItem;
import cool.doudou.doudada.wechat.core.entity.xml.msg.ImgTextMsg;
import cool.doudou.doudada.wechat.core.entity.xml.msg.TextMsg;
import cool.doudou.doudada.wechat.core.util.XmlUtil;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ReplyMsgHelper {
    private static final Logger log = LoggerFactory.getLogger(ReplyMsgHelper.class);

    public void ok(String content) {
        this.write(content);
    }

    public void text(String fromUserName, String toUserName, String content) {
        try {
            TextMsg textMsg = new TextMsg();
            textMsg.setFromUserName(fromUserName);
            textMsg.setToUserName(toUserName);
            textMsg.setCreateTime(System.currentTimeMillis());
            textMsg.setMsgType("text");
            textMsg.setContent(content);
            this.write(XmlUtil.marshal(textMsg, TextMsg.class));
            log.info("\u56de\u590d\u6587\u672c\u6d88\u606f\u6210\u529f\uff1a{}", (Object)fromUserName);
        }
        catch (Exception e) {
            log.error("\u56de\u590d\u6587\u672c\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public void imgText(String fromUserName, String toUserName, List<Map<String, String>> articleList) {
        try {
            ImgTextMsg imgTextMsg = new ImgTextMsg();
            imgTextMsg.setFromUserName(fromUserName);
            imgTextMsg.setToUserName(toUserName);
            imgTextMsg.setCreateTime(System.currentTimeMillis());
            imgTextMsg.setMsgType("news");
            imgTextMsg.setArticleCount(articleList.size());
            ImgTextItem imgTextItem = new ImgTextItem();
            for (Map<String, String> article : articleList) {
                ImgTextArticle imgTextArticle = new ImgTextArticle();
                imgTextArticle.setTitle(article.get("title"));
                imgTextArticle.setDescription(article.get("description"));
                imgTextArticle.setPicUrl(article.get("picUrl"));
                imgTextArticle.setUrl(article.get("url"));
                imgTextItem.add(imgTextArticle);
            }
            imgTextMsg.setImgTextItem(imgTextItem);
            this.write(XmlUtil.marshal(imgTextMsg, ImgTextMsg.class));
            log.info("\u56de\u590d\u56fe\u6587\u6d88\u606f\u6210\u529f\uff1a{}", (Object)toUserName);
        }
        catch (Exception e) {
            log.error("\u56de\u590d\u56fe\u6587\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String content) {
        Writer writer = null;
        try {
            HttpServletResponse response = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getResponse();
            assert (response != null);
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            writer = response.getWriter();
            writer.write(content);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

