/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.core.processor;

import cool.doudou.doudada.wechat.annotation.WechatNotify;
import cool.doudou.doudada.wechat.core.factory.MethodFactory;
import cool.doudou.doudada.wechat.core.method.NotifyMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WechatNotifyBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(WechatNotifyBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(WechatNotify.class)).forEach(method -> {
            if (method.getReturnType() != Boolean.TYPE) {
                log.error("@WechatNotify annotated method must return boolean, but is : {}", method.getReturnType());
                return;
            }
            if (MethodFactory.getNotify() != null) {
                log.error("there are multiple @WechatNotify annotations");
                return;
            }
            MethodFactory.setNotify(NotifyMethod.builder().bean(bean).method((Method)method).build());
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

