/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.core.processor;

import cool.doudou.doudada.wechat.annotation.WechatOAuth2;
import cool.doudou.doudada.wechat.core.factory.MethodFactory;
import cool.doudou.doudada.wechat.core.method.OAuth2Method;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WechatOAuth2BeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(WechatOAuth2BeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(WechatOAuth2.class)).forEach(method -> {
            if (method.getReturnType() != String.class) {
                log.error("@WechatOAuth2 annotated method must return String, but is : {}", method.getReturnType());
                return;
            }
            if (MethodFactory.getOAuth2() != null) {
                log.error("there are multiple @WechatOAuth2 annotations");
                return;
            }
            MethodFactory.setOAuth2(OAuth2Method.builder().bean(bean).method((Method)method).build());
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

