/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.core.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolUtil.class);
    private static final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2, new ScheduledThreadFactory());

    public static ScheduledThreadPoolExecutor getScheduledInstance() {
        return scheduledThreadPoolExecutor;
    }

    private static class ScheduledThreadFactory
    implements ThreadFactory {
        private final AtomicInteger count = new AtomicInteger(0);

        private ScheduledThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = "wechat_scheduled_" + this.count.addAndGet(1);
            Thread t = new Thread(r);
            t.setName(threadName);
            log.info("new scheduledThread[{}]: taskCount[{}] = queueSize[{}] + activeCount[{}] + completedTaskCount[{}] ", new Object[]{threadName, scheduledThreadPoolExecutor.getTaskCount(), scheduledThreadPoolExecutor.getQueue().size(), scheduledThreadPoolExecutor.getActiveCount(), scheduledThreadPoolExecutor.getCompletedTaskCount()});
            return t;
        }
    }
}

