/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.wechat.rest.service;

import com.alibaba.fastjson2.JSONObject;
import cool.doudou.doudada.wechat.core.api.WechatApi;
import cool.doudou.doudada.wechat.core.entity.Credential;
import cool.doudou.doudada.wechat.core.entity.JsSignature;
import cool.doudou.doudada.wechat.core.entity.xml.ReceiveMsg;
import cool.doudou.doudada.wechat.core.factory.MethodFactory;
import cool.doudou.doudada.wechat.core.factory.TokenMapFactory;
import cool.doudou.doudada.wechat.core.helper.ReplyMsgHelper;
import cool.doudou.doudada.wechat.core.method.NotifyMethod;
import cool.doudou.doudada.wechat.core.method.OAuth2Method;
import cool.doudou.doudada.wechat.core.util.SignUtil;
import cool.doudou.doudada.wechat.core.util.XmlUtil;
import cool.doudou.doudada.wechat.properties.WechatProperties;
import java.lang.reflect.Method;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.ModelAndView;

public class WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatService.class);
    private WechatProperties wechatProperties;
    private ReplyMsgHelper replyMsgHelper;

    public String check(String signature, String timestamp, String nonce, String echostr) {
        if (ObjectUtils.isEmpty((Object)signature) || ObjectUtils.isEmpty((Object)timestamp) || ObjectUtils.isEmpty((Object)nonce) || ObjectUtils.isEmpty((Object)echostr)) {
            log.error("\u5fae\u4fe1\u670d\u52a1\u5668\u9a8c\u8bc1\u5931\u8d25\uff1a\u53c2\u6570\u5f02\u5e38\uff0c\u62d2\u7edd\u8bbf\u95ee.");
            return "";
        }
        try {
            if (this.wechatProperties.getCredentials().isEmpty()) {
                log.error("\u5fae\u4fe1\u670d\u52a1\u5668\u9a8c\u8bc1\u5931\u8d25\uff1a\u53c2\u6570\u914d\u7f6e\u9519\u8bef.");
                return "";
            }
            for (Credential credential : this.wechatProperties.getCredentials()) {
                String signatureStr = SignUtil.server(credential.getToken(), timestamp, nonce);
                if (!signature.equals(signatureStr)) continue;
                log.info("\u5fae\u4fe1\u670d\u52a1\u5668\u9a8c\u8bc1\u901a\u8fc7\uff1aappId[{}]", (Object)credential.getAppId());
                return echostr;
            }
            log.error("\u5fae\u4fe1\u670d\u52a1\u5668\u9a8c\u8bc1\u5931\u8d25\uff1a\u62d2\u7edd\u8bbf\u95ee.");
            return "";
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u670d\u52a1\u5668\u9a8c\u8bc1\u5f02\u5e38\uff1a\u62d2\u7edd\u8bbf\u95ee.\uff1a", (Throwable)e);
            return "";
        }
    }

    public void notify(String xml) {
        log.info("notify\uff1a{}", (Object)xml);
        try {
            ReceiveMsg receiveMsg = (ReceiveMsg)XmlUtil.unMarshal(xml, ReceiveMsg.class);
            NotifyMethod notifyMethod = MethodFactory.getNotify();
            if (notifyMethod != null) {
                Object bean = notifyMethod.getBean();
                Method method = notifyMethod.getMethod();
                try {
                    method.setAccessible(true);
                    Boolean respFlag = (Boolean)method.invoke(bean, receiveMsg);
                    if (respFlag.booleanValue()) {
                        this.replyMsgHelper.ok("success");
                    }
                }
                catch (Exception e) {
                    log.error("bean[{}].method[{}] invoke exception: ", new Object[]{bean, method.getName(), e});
                }
                return;
            }
            log.warn("No NotifyMethod found");
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u901a\u77e5\u5f02\u5e38", (Throwable)e);
        }
    }

    public ModelAndView oauth2(String code, String state) {
        ModelAndView modelAndView;
        log.info("oauth2: {}, {}", (Object)code, (Object)state);
        try {
            String[] stateArray = state.split("_");
            if (stateArray.length == 0) {
                throw new RuntimeException("\u5fae\u4fe1\u6388\u6743\u56de\u6389\u53c2\u6570state\u9a8c\u8bc1\u5931\u8d25");
            }
            String appId = stateArray[0];
            String secret = null;
            if (this.wechatProperties.getCredentials().isEmpty()) {
                log.error("\u5fae\u4fe1\u670d\u52a1\u5668\u53c2\u6570\u914d\u7f6e\u9519\u8bef.");
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u5668\u53c2\u6570\u914d\u7f6e\u9519\u8bef");
            }
            for (Credential credential : this.wechatProperties.getCredentials()) {
                if (!appId.equals(credential.getAppId())) continue;
                secret = credential.getSecret();
                break;
            }
            if (secret == null) {
                throw new RuntimeException("\u5fae\u4fe1\u6388\u6743\u5bc6\u94a5\u9a8c\u8bc1\u5931\u8d25");
            }
            JSONObject resultObj = WechatApi.oauth2Token(appId, secret, code);
            if (resultObj == null) {
                throw new RuntimeException("\u5fae\u4fe1\u6388\u6743\u9a8c\u8bc1\u5931\u8d25");
            }
            String openId = resultObj.getString("openid");
            if (ObjectUtils.isEmpty((Object)openId)) {
                throw new RuntimeException("\u5fae\u4fe1\u901a\u8baf\u6807\u8bc6\u83b7\u53d6\u5931\u8d25");
            }
            JSONObject userInfo = WechatApi.getUserInfo(openId, resultObj.getString("access_token"));
            if (ObjectUtils.isEmpty((Object)userInfo)) {
                throw new RuntimeException("\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
            }
            String route = null;
            OAuth2Method oauth2Method = MethodFactory.getOAuth2();
            if (oauth2Method != null) {
                Object bean = oauth2Method.getBean();
                Method method = oauth2Method.getMethod();
                try {
                    method.setAccessible(true);
                    route = (String)method.invoke(bean, state, userInfo);
                }
                catch (Exception e) {
                    log.error("bean[{}].method[{}] invoke exception: ", new Object[]{bean, method.getName(), e});
                }
            }
            log.info("oauth2 invoke route: {}", route);
            if (route == null) {
                throw new RuntimeException("OAuth2Method not exists");
            }
            modelAndView = new ModelAndView("redirect:" + this.wechatProperties.getCallbackServerAddress() + "/#/" + route);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u6388\u6743oauth2\u5f02\u5e38\uff1a", (Throwable)e);
            modelAndView = new ModelAndView("redirect:" + this.wechatProperties.getCallbackServerAddress() + "/#/error");
        }
        return modelAndView;
    }

    public JsSignature jsSign(String appId, String url) {
        String nonceStr = UUID.randomUUID().toString();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        JsSignature jsSignature = new JsSignature();
        jsSignature.setSignature(SignUtil.js(TokenMapFactory.get("js_api_ticket_" + appId), nonceStr, timestamp, url));
        jsSignature.setNonceStr(nonceStr);
        jsSignature.setTimestamp(timestamp);
        return jsSignature;
    }

    public String accessToken() {
        this.wechatProperties.getCredentials().forEach(credential -> WechatApi.accessToken(credential.getAppId(), credential.getSecret()));
        return "ok";
    }

    public String jsApiTicket() {
        this.wechatProperties.getCredentials().forEach(credential -> WechatApi.jsApiTicket(credential.getAppId()));
        return "ok";
    }

    public String getMenu(String appId) {
        JSONObject resultObj = WechatApi.getMenu(appId);
        if (resultObj != null) {
            return resultObj.toString();
        }
        return null;
    }

    public boolean createMenu(String appId, String json) {
        JSONObject resultObj = WechatApi.createMenu(appId, json);
        if (resultObj != null) {
            int code = resultObj.getInteger("errcode");
            return 0 == code;
        }
        return false;
    }

    public boolean deleteMenu(String appId) {
        JSONObject resultObj = WechatApi.deleteMenu(appId);
        if (resultObj != null) {
            int code = resultObj.getInteger("errcode");
            return 0 == code;
        }
        return false;
    }

    @Autowired
    public void setWechatProperties(WechatProperties wechatProperties) {
        this.wechatProperties = wechatProperties;
    }

    @Autowired
    public void setRespMsgHelper(ReplyMsgHelper replyMsgHelper) {
        this.replyMsgHelper = replyMsgHelper;
    }
}

