/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mqtt.assistant.core.helper;

import cool.doudou.mqtt.assistant.core.handler.MqttGatewayHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MqttHelper {
    private static final Logger log = LoggerFactory.getLogger(MqttHelper.class);
    private MqttGatewayHandler mqttGatewayHandler;

    public boolean send(byte[] payload) {
        try {
            this.mqttGatewayHandler.send(payload);
            return true;
        }
        catch (Exception e) {
            log.error("send payload[{}] exception: ", (Object)payload, (Object)e);
            return false;
        }
    }

    public boolean send(String topic, byte[] payload) {
        try {
            this.mqttGatewayHandler.send(topic, payload);
            return true;
        }
        catch (Exception e) {
            log.error("send topic[{}] payload[{}] exception: ", new Object[]{topic, payload, e});
            return false;
        }
    }

    @Autowired(required=false)
    public void setMqttGatewayHandler(MqttGatewayHandler mqttGatewayHandler) {
        this.mqttGatewayHandler = mqttGatewayHandler;
    }
}

