/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mqtt.assistant.core.helper;

import cool.doudou.mqtt.assistant.core.handler.MqttGatewayHandler;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MqttHelper {
    private static final Logger log = LoggerFactory.getLogger(MqttHelper.class);
    private MqttGatewayHandler mqttGatewayHandler;

    public boolean send(String topic, String payload) {
        return this.send(topic, payload.getBytes(StandardCharsets.UTF_8));
    }

    public boolean send(String topic, byte[] payload) {
        try {
            this.mqttGatewayHandler.send(topic, payload);
            return true;
        }
        catch (Exception e) {
            log.error("send topic[{}],payload[{}] exception: ", new Object[]{topic, payload, e});
            return false;
        }
    }

    public boolean send(String topic, int pos, String payload) {
        return this.send(topic, pos, payload.getBytes(StandardCharsets.UTF_8));
    }

    public boolean send(String topic, int pos, byte[] payload) {
        try {
            this.mqttGatewayHandler.send(topic, pos, payload);
            return true;
        }
        catch (Exception e) {
            log.error("send topic[{}],pos[{}],payload[{}] exception: ", new Object[]{topic, pos, payload, e});
            return false;
        }
    }

    @Autowired(required=false)
    public void setMqttGatewayHandler(MqttGatewayHandler mqttGatewayHandler) {
        this.mqttGatewayHandler = mqttGatewayHandler;
    }
}

