/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.boot.starter.config;

import cool.doudou.mybatis.assistant.boot.starter.interceptor.InterceptorFactory;
import cool.doudou.mybatis.assistant.boot.starter.properties.MybatisAssistantProperties;
import cool.doudou.mybatis.assistant.core.fill.IFieldFillHandler;
import cool.doudou.mybatis.assistant.expansion.dialect.DialectHandlerFactory;
import cool.doudou.mybatis.assistant.expansion.dialect.IDialectHandler;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MybatisAssistantConfig {
    private MybatisAssistantProperties mybatisAssistantProperties;
    private IFieldFillHandler fieldFillHandler;
    @Value(value="${spring.datasource.url}")
    private String jdbcUrl;

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        factoryBean.setMapperLocations(resourcePatternResolver.getResources(this.mybatisAssistantProperties.getMapperLocations()));
        SqlSessionFactory sqlSessionFactory = factoryBean.getObject();
        this.addInterceptor(sqlSessionFactory);
        return sqlSessionFactory;
    }

    private void addInterceptor(SqlSessionFactory sqlSessionFactory) {
        Interceptor interceptor;
        IDialectHandler dialectHandler = DialectHandlerFactory.getInstance((String)this.jdbcUrl);
        if (dialectHandler != null && (interceptor = InterceptorFactory.getInstance("query")) != null) {
            Properties properties = new Properties();
            properties.put("dialectHandler", dialectHandler);
            interceptor.setProperties(properties);
            sqlSessionFactory.getConfiguration().addInterceptor(interceptor);
            System.out.println("interceptor[query] add ok.");
        }
        this.mybatisAssistantProperties.getInterceptors().forEach(key -> {
            Interceptor interceptor = InterceptorFactory.getInstance(key);
            if (interceptor != null) {
                if ("fieldFill".equals(key)) {
                    if (this.fieldFillHandler != null) {
                        Properties properties = new Properties();
                        properties.put("fieldFillHandler", this.fieldFillHandler);
                        interceptor.setProperties(properties);
                        sqlSessionFactory.getConfiguration().addInterceptor(interceptor);
                        System.out.println("interceptor[" + key + "] add ok.");
                    }
                } else {
                    sqlSessionFactory.getConfiguration().addInterceptor(interceptor);
                    System.out.println("interceptor[" + key + "] add ok.");
                }
            }
        });
    }

    @Autowired
    public void setMybatisAssistantProperties(MybatisAssistantProperties mybatisAssistantProperties) {
        this.mybatisAssistantProperties = mybatisAssistantProperties;
    }

    @Autowired(required=false)
    public void setFieldFillHandler(IFieldFillHandler fieldFillHandler) {
        this.fieldFillHandler = fieldFillHandler;
    }
}

