/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.boot.starter.config;

import cool.doudou.mybatis.assistant.boot.starter.interceptor.InterceptorFactory;
import cool.doudou.mybatis.assistant.boot.starter.properties.MybatisAssistantProperties;
import cool.doudou.mybatis.assistant.core.handler.IDeletedFillHandler;
import cool.doudou.mybatis.assistant.core.handler.IDesensitizeHandler;
import cool.doudou.mybatis.assistant.core.handler.IFieldFillHandler;
import cool.doudou.mybatis.assistant.core.handler.ITenantFillHandler;
import cool.doudou.mybatis.assistant.expansion.dialect.DialectHandlerFactory;
import cool.doudou.mybatis.assistant.expansion.dialect.IDialectHandler;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MybatisAssistantConfig {
    private MybatisAssistantProperties mybatisAssistantProperties;
    private IFieldFillHandler fieldFillHandler;
    private IDeletedFillHandler deletedFillHandler;
    private ITenantFillHandler tenantFillHandler;
    private IDesensitizeHandler desensitizeHandler;
    @Value(value="${spring.datasource.url}")
    private String jdbcUrl;

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        factoryBean.setMapperLocations(resourcePatternResolver.getResources(this.mybatisAssistantProperties.getMapperLocations()));
        SqlSessionFactory sqlSessionFactory = factoryBean.getObject();
        this.addInterceptor(sqlSessionFactory);
        return sqlSessionFactory;
    }

    private void addInterceptor(SqlSessionFactory sqlSessionFactory) {
        Interceptor desensitizeInterceptor;
        Interceptor fillInterceptor;
        Interceptor queryInterceptor = InterceptorFactory.getInstance("query");
        if (queryInterceptor != null) {
            Properties properties = new Properties();
            IDialectHandler dialectHandler = DialectHandlerFactory.getInstance((String)this.jdbcUrl);
            if (dialectHandler != null) {
                properties.put("dialectHandler", dialectHandler);
                queryInterceptor.setProperties(properties);
                sqlSessionFactory.getConfiguration().addInterceptor(queryInterceptor);
                System.out.println("interceptor[query] add ok.");
            }
        }
        if ((fillInterceptor = InterceptorFactory.getInstance("fill")) != null) {
            if (this.fieldFillHandler == null) {
                System.err.println("interceptor[fill].fieldFillHandler must be initialized");
            } else if (this.deletedFillHandler == null) {
                System.err.println("interceptor[fill].deletedFillHandler must be initialized");
            } else if (this.tenantFillHandler == null) {
                System.err.println("interceptor[fill].tenantFillHandler must be initialized");
            } else {
                Properties properties = new Properties();
                properties.put("fieldFillHandler", this.fieldFillHandler);
                properties.put("deletedFillHandler", this.deletedFillHandler);
                properties.put("tenantFillHandler", this.tenantFillHandler);
                fillInterceptor.setProperties(properties);
                sqlSessionFactory.getConfiguration().addInterceptor(fillInterceptor);
                System.out.println("interceptor[fill] add ok.");
            }
        }
        if ((desensitizeInterceptor = InterceptorFactory.getInstance("desensitize")) != null && this.desensitizeHandler != null) {
            Properties properties = new Properties();
            properties.put("desensitizeHandler", this.desensitizeHandler);
            desensitizeInterceptor.setProperties(properties);
            sqlSessionFactory.getConfiguration().addInterceptor(desensitizeInterceptor);
            System.out.println("interceptor[desensitize] add ok.");
        }
    }

    @Autowired
    public void setMybatisAssistantProperties(MybatisAssistantProperties mybatisAssistantProperties) {
        this.mybatisAssistantProperties = mybatisAssistantProperties;
    }

    @Autowired(required=false)
    public void setFieldFillHandler(IFieldFillHandler fieldFillHandler) {
        this.fieldFillHandler = fieldFillHandler;
    }

    @Autowired(required=false)
    public void setDeletedFillHandler(IDeletedFillHandler deletedFillHandler) {
        this.deletedFillHandler = deletedFillHandler;
    }

    @Autowired(required=false)
    public void setTenantFillHandler(ITenantFillHandler tenantFillHandler) {
        this.tenantFillHandler = tenantFillHandler;
    }

    @Autowired(required=false)
    public void setDesensitizeHandler(IDesensitizeHandler desensitizeHandler) {
        this.desensitizeHandler = desensitizeHandler;
    }
}

