/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.interceptors;

import cool.doudou.mybatis.assistant.core.dialect.IDialectHandler;
import cool.doudou.mybatis.assistant.core.helper.PageHelper;
import cool.doudou.mybatis.assistant.core.page.Page;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class QueryInterceptor
implements Interceptor {
    private volatile IDialectHandler dialectHandler;

    public Object intercept(Invocation invocation) throws Throwable {
        Page page;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        BoundSql boundSql = statementHandler.getBoundSql();
        Object parameterObject = boundSql.getParameterObject();
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        Field additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
        additionalParametersField.setAccessible(true);
        Map additionalParameterMap = (Map)additionalParametersField.get(boundSql);
        String id = mappedStatement.getId();
        if (id.matches(".+Page$") && (page = PageHelper.getPage(parameterObject)) != null) {
            Connection connection = (Connection)invocation.getArgs()[0];
            BoundSql countBoundSql = this.dialectHandler.getCountSql(mappedStatement, parameterObject, boundSql, additionalParameterMap);
            PreparedStatement preparedStatement = connection.prepareStatement(countBoundSql.getSql());
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
            parameterHandler.setParameters(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            long count = 0L;
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            page.setTotal(count);
            if (count <= 0L) {
                return Collections.emptyList();
            }
            boundSql = this.dialectHandler.getPageSql(mappedStatement, parameterObject, boundSql, additionalParameterMap, page);
        }
        metaObject.setValue("delegate.boundSql", (Object)boundSql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        if (!properties.isEmpty()) {
            this.dialectHandler = (IDialectHandler)properties.get("dialectHandler");
        }
    }
}

