/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.interceptors;

import cool.doudou.mybatis.assistant.core.handler.IDeletedFillHandler;
import cool.doudou.mybatis.assistant.core.handler.IFieldFillHandler;
import cool.doudou.mybatis.assistant.core.handler.IIdFillHandler;
import cool.doudou.mybatis.assistant.core.handler.ITenantFillHandler;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class FillInterceptor
implements Interceptor {
    private volatile IIdFillHandler idFillHandler;
    private volatile IFieldFillHandler fieldFillHandler;
    private volatile IDeletedFillHandler deletedFillHandler;
    private volatile ITenantFillHandler tenantFillHandler;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        MetaObject metaObject = SystemMetaObject.forObject((Object)args[1]);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.INSERT) {
            if (this.idFillHandler != null) {
                this.idFillHandler.fill(metaObject);
            }
            if (this.fieldFillHandler != null) {
                this.fieldFillHandler.insert(metaObject);
            }
            if (this.deletedFillHandler != null) {
                this.deletedFillHandler.fill(metaObject);
            }
            if (this.tenantFillHandler != null) {
                this.tenantFillHandler.fill(metaObject);
            }
        } else if (sqlCommandType == SqlCommandType.UPDATE && this.fieldFillHandler != null) {
            this.fieldFillHandler.update(metaObject);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        if (!properties.isEmpty()) {
            this.idFillHandler = (IIdFillHandler)properties.get("idFillHandler");
            this.fieldFillHandler = (IFieldFillHandler)properties.get("fieldFillHandler");
            this.deletedFillHandler = (IDeletedFillHandler)properties.get("deletedFillHandler");
            this.tenantFillHandler = (ITenantFillHandler)properties.get("tenantFillHandler");
        }
    }
}

