/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.interceptors;

import cool.doudou.mybatiis.assistant.annotation.Desensitize;
import cool.doudou.mybatiis.assistant.annotation.enums.StrategyEnum;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class DesensitizeInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        List list = (List)invocation.proceed();
        list.forEach(this::process);
        return list;
    }

    private void process(Object source) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)source);
        Arrays.stream(source.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(Desensitize.class)).forEach(f -> {
            String name = f.getName();
            Object value = metaObject.getValue(name);
            if (metaObject.getGetterType(name) == String.class && value != null) {
                Desensitize desensitize = f.getAnnotation(Desensitize.class);
                StrategyEnum strategy = desensitize.strategy();
                metaObject.setValue(name, strategy.getFunction().apply(String.valueOf(value)));
            }
        });
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

