/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.interceptors;

import cool.doudou.mybatiis.assistant.annotation.Desensitize;
import cool.doudou.mybatis.assistant.core.handler.IDesensitizeHandler;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class DesensitizeInterceptor
implements Interceptor {
    private static final Map<String, Function<String, String>> STRATEGY_MAP = new HashMap<String, Function<String, String>>();

    public Object intercept(Invocation invocation) throws Throwable {
        List list = (List)invocation.proceed();
        if (list != null && !list.isEmpty()) {
            list.forEach(this::process);
        }
        return list;
    }

    private void process(Object source) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)source);
        Arrays.stream(source.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(Desensitize.class)).forEach(f -> {
            Desensitize desensitize;
            Function<String, String> desensitizeFunction;
            String name = f.getName();
            Object value = metaObject.getValue(name);
            if (metaObject.getGetterType(name) == String.class && value != null && (desensitizeFunction = STRATEGY_MAP.get((desensitize = f.getAnnotation(Desensitize.class)).strategy())) != null) {
                metaObject.setValue(name, (Object)desensitizeFunction.apply(String.valueOf(value)));
            }
        });
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        IDesensitizeHandler desensitizeHandler;
        if (!properties.isEmpty() && (desensitizeHandler = (IDesensitizeHandler)properties.get("desensitizeHandler")) != null) {
            STRATEGY_MAP.putAll(desensitizeHandler.customize());
        }
    }

    static {
        STRATEGY_MAP.put("userName", s -> s.replaceAll("(\\S)\\S(\\S*)", "$1*$2"));
        STRATEGY_MAP.put("idCard", s -> s.replaceAll("(?<=\\w{3})\\w(?=\\w{4})", "*"));
        STRATEGY_MAP.put("phoneNumber", s -> s.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
    }
}

