/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.query;

import cool.doudou.mybatiis.assistant.annotation.QueryInfo;
import cool.doudou.mybatiis.assistant.annotation.enums.QueryOprEnum;
import cool.doudou.mybatis.assistant.core.enums.SqlKeyword;
import cool.doudou.mybatis.assistant.expansion.util.ComUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseQuery {
    private final List<String> whereList = new ArrayList<String>();
    private final Map<String, Object> whereParamMap = new HashMap<String, Object>();
    private final List<String> orderByList = new ArrayList<String>();
    private final Set<String> groupBySet = new LinkedHashSet<String>();
    private final Set<String> havingSet = new LinkedHashSet<String>();

    protected void clear() {
        this.whereList.clear();
        this.whereParamMap.clear();
        this.orderByList.clear();
        this.groupBySet.clear();
        this.havingSet.clear();
    }

    protected void where(String column, SqlKeyword sqlKeyword, Object value) {
        String propertyName = ComUtil.underline2Hump((String)column);
        this.whereList.add("(" + String.join((CharSequence)" ", column, sqlKeyword.get(), "#{q.param." + propertyName + "}") + ")");
        this.whereParamMap.put(propertyName, value);
    }

    protected void whereBetween(String column, Object valueStart, Object valueEnd) {
        String propertyName = ComUtil.underline2Hump((String)column);
        String betweenStart = "Start";
        String betweenEnd = "End";
        this.whereList.add("(" + String.join((CharSequence)" ", column, SqlKeyword.BETWEEN.get(), "#{q.param." + propertyName + betweenStart + "}", SqlKeyword.AND.get(), "#{q.param." + propertyName + betweenEnd + "}") + ")");
        this.whereParamMap.put(propertyName + betweenStart, valueStart);
        this.whereParamMap.put(propertyName + betweenEnd, valueEnd);
    }

    protected void orderBy(String column, SqlKeyword sqlKeyword) {
        this.orderByList.add(String.join((CharSequence)" ", column, sqlKeyword.get()));
    }

    protected void groupBy(Set<String> columns) {
        this.groupBySet.addAll(columns);
    }

    protected void havingBy(String column, String opr, Object value) {
        this.havingSet.add(String.join((CharSequence)" ", column, opr, String.valueOf(value)));
    }

    protected <T> void assign(T t) {
        if (t != null) {
            Arrays.stream(t.getClass().getDeclaredFields()).forEach(field -> {
                try {
                    if (field.isAnnotationPresent(QueryInfo.class)) {
                        field.setAccessible(true);
                        Object value = field.get(t);
                        if (value != null) {
                            String column = ComUtil.hump2Underline((String)field.getName());
                            QueryInfo queryInfo = field.getDeclaredAnnotation(QueryInfo.class);
                            QueryOprEnum queryOprEnum = queryInfo.opr();
                            switch (queryOprEnum) {
                                case EQ: {
                                    this.where(column, SqlKeyword.EQ, value);
                                    break;
                                }
                                case NOT_EQ: {
                                    this.where(column, SqlKeyword.NOT_EQ, value);
                                    break;
                                }
                                default: {
                                    System.err.println("opr[" + queryOprEnum + "] match fail");
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    protected String getSql() {
        StringBuilder sbQuerySql = new StringBuilder();
        if (!this.whereList.isEmpty()) {
            sbQuerySql.append(SqlKeyword.WHERE.get()).append(" ").append(String.join((CharSequence)(" " + SqlKeyword.AND.get() + " "), this.whereList));
        }
        if (!this.groupBySet.isEmpty()) {
            sbQuerySql.append(" ").append(SqlKeyword.GROUP_BY.get()).append(" ").append(String.join((CharSequence)",", this.groupBySet));
            if (!this.havingSet.isEmpty()) {
                sbQuerySql.append(" ").append(SqlKeyword.HAVING.get()).append(" ").append(String.join((CharSequence)",", this.havingSet));
            }
        }
        if (!this.orderByList.isEmpty()) {
            sbQuerySql.append(" ").append(SqlKeyword.ORDER_BY.get()).append(" ").append(String.join((CharSequence)",", this.orderByList));
        }
        return sbQuerySql.toString();
    }

    protected Map<String, Object> getParam() {
        return this.whereParamMap;
    }
}

