/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.generator;

import cool.doudou.mybatis.assistant.expansion.dialect.DialectHandlerFactory;
import cool.doudou.mybatis.assistant.expansion.dialect.IDialectHandler;
import cool.doudou.mybatis.assistant.expansion.util.ComUtil;
import cool.doudou.mybatis.assistant.generator.config.DataSourceConfig;
import cool.doudou.mybatis.assistant.generator.config.GlobalConfig;
import cool.doudou.mybatis.assistant.generator.config.PackageConfig;
import cool.doudou.mybatis.assistant.generator.config.TableConfig;
import cool.doudou.mybatis.assistant.generator.entity.ClassField;
import cool.doudou.mybatis.assistant.generator.entity.ClassInstance;
import cool.doudou.mybatis.assistant.generator.entity.DbColumn;
import cool.doudou.mybatis.assistant.generator.entity.DbTable;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class CodeGenerator {
    private final DataSourceConfig dataSourceConfig;
    private GlobalConfig globalConfig;
    private PackageConfig packageConfig;
    private TableConfig tableConfig;

    public CodeGenerator(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
        this.globalConfig = new GlobalConfig();
        this.packageConfig = new PackageConfig();
        this.tableConfig = new TableConfig();
    }

    public static CodeGenerator create(String ip, int port, String user, String password) {
        return new CodeGenerator(new DataSourceConfig(ip, port, user, password));
    }

    public CodeGenerator globalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public CodeGenerator packageConfig(PackageConfig packageConfig) {
        this.packageConfig = packageConfig;
        return this;
    }

    public CodeGenerator tableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
        return this;
    }

    public void execute() {
        Properties properties = new Properties();
        properties.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)properties);
        IDialectHandler dialectHandler = DialectHandlerFactory.getInstance((String)this.dataSourceConfig.getUrl());
        if (dialectHandler == null) {
            System.err.println("\u6570\u636e\u5e93\u65b9\u8a00\u5339\u914d\u5931\u8d25");
            return;
        }
        String driverClassName = dialectHandler.getDriverClassName();
        String tableSql = dialectHandler.getTableSql();
        String columnSql = dialectHandler.getColumnSql();
        this.tableConfig.getNameList().forEach(tableName -> {
            DbTable dbTable = this.getTableInfo(driverClassName, (String)tableName, tableSql, columnSql);
            if (dbTable != null) {
                this.output(dbTable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbTable getTableInfo(String driverClassName, String tableName, String tableSql, String columnSql) {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Class.forName(driverClassName);
            connection = DriverManager.getConnection(this.dataSourceConfig.getUrl(), this.dataSourceConfig.getUser(), this.dataSourceConfig.getPassword());
            preparedStatement = connection.prepareStatement(tableSql);
            preparedStatement.setString(1, this.tableConfig.getSchema());
            preparedStatement.setString(2, tableName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                DbTable dbTable = new DbTable();
                dbTable.setName(tableName);
                dbTable.setComment(String.valueOf(resultSet.getObject("TABLE_COMMENT")));
                ArrayList<DbColumn> dbColumnList = new ArrayList<DbColumn>();
                preparedStatement = connection.prepareStatement(columnSql);
                preparedStatement.setString(1, this.tableConfig.getSchema());
                preparedStatement.setString(2, tableName);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    DbColumn dbColumn = new DbColumn();
                    dbColumn.setName(String.valueOf(resultSet.getObject("COLUMN_NAME")));
                    dbColumn.setDataType(String.valueOf(resultSet.getObject("DATA_TYPE")));
                    dbColumn.setComment(String.valueOf(resultSet.getObject("COLUMN_COMMENT")));
                    dbColumn.setKey(String.valueOf(resultSet.getObject("COLUMN_KEY")));
                    dbColumnList.add(dbColumn);
                }
                dbTable.setColumnList(dbColumnList);
                DbTable dbTable2 = dbTable;
                return dbTable2;
            }
            System.err.println("prompt: table[" + tableName + "] not exists");
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void output(DbTable dbTable) {
        Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
        Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
        Map<String, Object> contextMap = this.contextMap(dbTable);
        Map<String, String> templateMap = this.templateMap((ClassInstance)contextMap.get("instance"));
        for (Map.Entry<String, String> entry : templateMap.entrySet()) {
            String templateName = entry.getKey();
            String fileName = entry.getValue();
            File parentFile = new File(this.globalConfig.getOutputDir());
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                String directory = parentFile.getAbsolutePath();
                FileWriter writer = new FileWriter(directory + File.separator + fileName);
                Template template = Velocity.getTemplate((String)templateName, (String)StandardCharsets.UTF_8.name());
                template.merge((Context)new VelocityContext(contextMap), (Writer)writer);
                writer.flush();
                writer.close();
                this.openDir(directory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void openDir(String directory) throws Exception {
        if (this.globalConfig.isOpenDir()) {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + directory);
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + directory);
                } else {
                    System.err.println("\u64cd\u4f5c\u7cfb\u7edf[" + osName + "]\u5339\u914d\u5931\u8d25: \u76ee\u5f55 => " + directory);
                }
            } else {
                System.err.println("\u64cd\u4f5c\u7cfb\u7edf\u83b7\u53d6\u5931\u8d25");
            }
        }
    }

    private Map<String, Object> contextMap(DbTable dbTable) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(8);
        contextMap.put("tableName", dbTable.getName());
        contextMap.put("tableComment", dbTable.getComment());
        contextMap.put("author", this.globalConfig.getAuthor());
        contextMap.put("date", new SimpleDateFormat("yyyy/MM/dd").format(new Date()));
        contextMap.put("package", this.packageConfig);
        contextMap.put("instance", this.instance(dbTable.getName()));
        contextMap.put("entityMap", this.entityMap(dbTable.getColumnList()));
        return contextMap;
    }

    private ClassInstance instance(String tableName) {
        int firstIndex = tableName.indexOf("_");
        String underlineName = tableName.substring(firstIndex + 1);
        String name = ComUtil.underline2Hump((String)underlineName);
        String className = ComUtil.upperFirst((String)name);
        ClassInstance classInstance = new ClassInstance();
        classInstance.setController(name + "Controller");
        classInstance.setControllerClass(className + "Controller");
        classInstance.setService(name + "Service");
        classInstance.setServiceClass(className + "Service");
        classInstance.setMapper(name + "Mapper");
        classInstance.setMapperClass(className + "Mapper");
        classInstance.setEntity(name);
        classInstance.setEntityClass(className);
        return classInstance;
    }

    private Map<String, Object> entityMap(List<DbColumn> columnList) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>(3);
        entityMap.put("columnList", columnList);
        ArrayList fieldList = new ArrayList();
        HashSet pkgSet = new HashSet();
        columnList.forEach(column -> {
            ClassField classField = new ClassField();
            classField.setName(ComUtil.underline2Hump((String)column.getName()));
            classField.setJavaType(ComUtil.convert2JavaType((String)column.getDataType()));
            classField.setComment(column.getComment());
            fieldList.add(classField);
            if ("Date".equals(classField.getJavaType())) {
                pkgSet.add("java.util.Date");
            } else if ("BigDecimal".equals(classField.getJavaType())) {
                pkgSet.add("java.math.BigDecimal");
            } else if ("Blob".equals(classField.getJavaType())) {
                pkgSet.add("java.sql.Blob");
            }
        });
        entityMap.put("fieldList", fieldList);
        entityMap.put("importPackages", pkgSet);
        return entityMap;
    }

    private Map<String, String> templateMap(ClassInstance instance) {
        String entityClass = instance.getEntityClass();
        HashMap<String, String> templateMap = new HashMap<String, String>(5);
        templateMap.put("template/controller.java.vm", entityClass + "Controller.java");
        templateMap.put("template/service.java.vm", entityClass + "Service.java");
        templateMap.put("template/mapper.java.vm", entityClass + "Mapper.java");
        templateMap.put("template/entity.java.vm", entityClass + ".java");
        templateMap.put("template/mapper.xml.vm", entityClass + "Mapper.xml");
        return templateMap;
    }
}

