/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.generator.output;

import cool.doudou.mybatis.assistant.expansion.util.ComUtil;
import cool.doudou.mybatis.assistant.generator.config.GlobalConfig;
import cool.doudou.mybatis.assistant.generator.config.PackageConfig;
import cool.doudou.mybatis.assistant.generator.entity.ClassField;
import cool.doudou.mybatis.assistant.generator.entity.ClassInstance;
import cool.doudou.mybatis.assistant.generator.entity.DbColumn;
import cool.doudou.mybatis.assistant.generator.entity.DbTable;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class OutputService {
    private final GlobalConfig globalConfig;
    private final PackageConfig packageConfig;

    public OutputService(GlobalConfig globalConfig, PackageConfig packageConfig) {
        this.globalConfig = globalConfig;
        this.packageConfig = packageConfig;
    }

    public void execute(DbTable dbTable) {
        Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
        Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
        Map<String, Object> contextMap = this.contextMap(dbTable);
        Map<String, String> templateMap = this.templateMap((ClassInstance)contextMap.get("instance"));
        for (Map.Entry<String, String> entry : templateMap.entrySet()) {
            String templateName = entry.getKey();
            String fileName = entry.getValue();
            File parentPath = new File(this.globalConfig.getOutputDir() + File.separator + this.packageConfig.getPath(fileName));
            if (!parentPath.exists()) {
                parentPath.mkdirs();
            }
            try {
                String directory = parentPath.getAbsolutePath();
                FileWriter writer = new FileWriter(directory + File.separator + fileName);
                Template template = Velocity.getTemplate((String)templateName, (String)StandardCharsets.UTF_8.name());
                template.merge((Context)new VelocityContext(contextMap), (Writer)writer);
                writer.flush();
                writer.close();
                this.openDir(directory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void openDir(String directory) throws Exception {
        if (this.globalConfig.isOpenDir()) {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + directory);
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + directory);
                } else {
                    System.err.println("\u64cd\u4f5c\u7cfb\u7edf[" + osName + "]\u5339\u914d\u5931\u8d25: \u76ee\u5f55 => " + directory);
                }
            } else {
                System.err.println("\u64cd\u4f5c\u7cfb\u7edf\u83b7\u53d6\u5931\u8d25");
            }
        }
    }

    private Map<String, Object> contextMap(DbTable dbTable) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(8);
        contextMap.put("tableName", dbTable.getName());
        contextMap.put("tableComment", dbTable.getComment());
        contextMap.put("author", this.globalConfig.getAuthor());
        contextMap.put("date", new SimpleDateFormat("yyyy/MM/dd").format(new Date()));
        contextMap.put("package", this.packageConfig);
        contextMap.put("instance", this.instance(dbTable.getName()));
        contextMap.put("entityMap", this.entityMap(dbTable.getColumnList()));
        return contextMap;
    }

    private ClassInstance instance(String tableName) {
        int firstIndex = tableName.indexOf("_");
        String underlineName = tableName.substring(firstIndex + 1);
        String name = ComUtil.underline2Hump((String)underlineName);
        String className = ComUtil.upperFirst((String)name);
        ClassInstance classInstance = new ClassInstance();
        classInstance.setController(name + "Controller");
        classInstance.setControllerClass(className + "Controller");
        classInstance.setService(name + "Service");
        classInstance.setServiceClass(className + "Service");
        classInstance.setMapper(name + "Mapper");
        classInstance.setMapperClass(className + "Mapper");
        classInstance.setEntity(name);
        classInstance.setEntityClass(className);
        return classInstance;
    }

    private Map<String, Object> entityMap(List<DbColumn> columnList) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>(3);
        entityMap.put("columnList", columnList);
        ArrayList fieldList = new ArrayList();
        HashSet pkgSet = new HashSet();
        columnList.forEach(column -> {
            ClassField classField = new ClassField();
            classField.setName(ComUtil.underline2Hump((String)column.getName()));
            classField.setJavaType(ComUtil.convert2JavaType((String)column.getDataType()));
            classField.setComment(column.getComment());
            fieldList.add(classField);
            if ("Date".equals(classField.getJavaType())) {
                pkgSet.add("java.util.Date");
            } else if ("BigDecimal".equals(classField.getJavaType())) {
                pkgSet.add("java.math.BigDecimal");
            } else if ("Blob".equals(classField.getJavaType())) {
                pkgSet.add("java.sql.Blob");
            }
        });
        entityMap.put("fieldList", fieldList);
        entityMap.put("importPackages", pkgSet);
        return entityMap;
    }

    private Map<String, String> templateMap(ClassInstance instance) {
        String entityClass = instance.getEntityClass();
        HashMap<String, String> templateMap = new HashMap<String, String>(5);
        templateMap.put("template/controller.java.vm", entityClass + "Controller.java");
        templateMap.put("template/service.java.vm", entityClass + "Service.java");
        templateMap.put("template/mapper.java.vm", entityClass + "Mapper.java");
        templateMap.put("template/entity.java.vm", entityClass + ".java");
        templateMap.put("template/mapper.xml.vm", entityClass + "Mapper.xml");
        return templateMap;
    }
}

