/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.generator.table;

import cool.doudou.mybatis.assistant.generator.config.DataSourceConfig;
import cool.doudou.mybatis.assistant.generator.config.TableConfig;
import cool.doudou.mybatis.assistant.generator.entity.DbColumn;
import cool.doudou.mybatis.assistant.generator.entity.DbTable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TableService {
    private final DataSourceConfig dataSourceConfig;
    private final TableConfig tableConfig;

    public TableService(DataSourceConfig dataSourceConfig, TableConfig tableConfig) {
        this.dataSourceConfig = dataSourceConfig;
        this.tableConfig = tableConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbTable getInfo(String tableName, String driverClassName, String tableSql, String columnSql) {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Class.forName(driverClassName);
            connection = DriverManager.getConnection(this.dataSourceConfig.getUrl(), this.dataSourceConfig.getUser(), this.dataSourceConfig.getPassword());
            preparedStatement = connection.prepareStatement(tableSql);
            preparedStatement.setString(1, this.tableConfig.getSchema());
            preparedStatement.setString(2, tableName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                DbTable dbTable = new DbTable();
                dbTable.setName(tableName);
                dbTable.setComment(String.valueOf(resultSet.getObject("TABLE_COMMENT")));
                ArrayList<DbColumn> dbColumnList = new ArrayList<DbColumn>();
                preparedStatement = connection.prepareStatement(columnSql);
                preparedStatement.setString(1, this.tableConfig.getSchema());
                preparedStatement.setString(2, tableName);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String columnName = String.valueOf(resultSet.getObject("COLUMN_NAME"));
                    if ("id".equals(columnName) || "create_by".equals(columnName) || "create_time".equals(columnName) || "update_by".equals(columnName) || "update_time".equals(columnName) || "deleted".equals(columnName)) continue;
                    DbColumn dbColumn = new DbColumn();
                    dbColumn.setName(columnName);
                    dbColumn.setDataType(String.valueOf(resultSet.getObject("DATA_TYPE")));
                    dbColumn.setComment(String.valueOf(resultSet.getObject("COLUMN_COMMENT")));
                    dbColumn.setKey(String.valueOf(resultSet.getObject("COLUMN_KEY")));
                    dbColumnList.add(dbColumn);
                }
                dbTable.setColumnList(dbColumnList);
                DbTable dbTable2 = dbTable;
                return dbTable2;
            }
            System.err.println("prompt: table[" + tableName + "] not exists");
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

