/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.cache;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import com.alicp.jetcache.anno.support.SpringConfigProvider;
import com.alicp.jetcache.support.CacheMessage;
import com.github.benmanes.caffeine.cache.Cache;
import cool.happycoding.code.cache.SyncCacheMessage;
import cool.happycoding.code.cache.SyncCachePostProcessor;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SyncRedisCacheMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(SyncRedisCacheMessageListener.class);
    private final SpringConfigProvider springConfigProvider;
    private final SyncCachePostProcessor syncCachePostProcessor;
    private final StringRedisTemplate stringRedisTemplate;

    public SyncRedisCacheMessageListener(SpringConfigProvider springConfigProvider, SyncCachePostProcessor syncCachePostProcessor, StringRedisTemplate stringRedisTemplate) {
        this.springConfigProvider = springConfigProvider;
        this.syncCachePostProcessor = syncCachePostProcessor;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void onMessage(Message message, byte[] pattern) {
        String msg = (String)this.stringRedisTemplate.getStringSerializer().deserialize(message.getBody());
        this.consumeMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void consumeMessage(String message) {
        log.info("syncCacheMessage:{}", (Object)message);
        try {
            SyncCacheMessage syncCacheMessage = SyncCacheMessage.syncCacheMessage(message);
            boolean isSelf = StrUtil.equalsAnyIgnoreCase((CharSequence)syncCacheMessage.getProducerAddr(), (CharSequence[])new CharSequence[]{SystemUtil.getHostInfo().getAddress()});
            if (isSelf) return;
            CacheMessage cacheMessage = syncCacheMessage.getCacheMessage();
            Cache cache = (Cache)this.springConfigProvider.getCacheManager().getCache(syncCacheMessage.getArea(), syncCacheMessage.getCacheName()).unwrap(Cache.class);
            switch (cacheMessage.getType()) {
                case 1: 
                case 3: {
                    Arrays.stream(cacheMessage.getKeys()).map(StrUtil::toString).filter(StrUtil::isNotBlank).forEach(arg_0 -> ((Cache)cache).invalidate(arg_0));
                    return;
                }
                case 4: {
                    cache.invalidateAll();
                    return;
                }
            }
            return;
        }
        catch (IllegalArgumentException e) {
            log.warn("sync cache error:{}", (Object)e.getMessage());
            return;
        }
        finally {
            this.syncCachePostProcessor.post(this.springConfigProvider, message);
        }
    }
}

