/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.cache;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="happy.code.cache")
public class HappyCacheProperties {
    public static final String HAPPY_CACHE_PREFIX = "happy.code.cache";
    private String[] hiddenPackages;
    private int statIntervalMinutes = 0;
    private boolean enableMethodCache = true;
    private String keyConvertor = "fastjson";
    private long localDefaultLimit = 100L;
    private long localDefaultExpireAfterAccessInMillis = 0L;
    private long localDefaultExpireAfterWriteInMillis = 0L;
    private long remoteDefaultExpireAfterWriteInMillis = 0L;
    private String bothCacheSyncTopic = "both-cache-sync";

    public String[] getHiddenPackages() {
        return this.hiddenPackages;
    }

    public int getStatIntervalMinutes() {
        return this.statIntervalMinutes;
    }

    public boolean isEnableMethodCache() {
        return this.enableMethodCache;
    }

    public String getKeyConvertor() {
        return this.keyConvertor;
    }

    public long getLocalDefaultLimit() {
        return this.localDefaultLimit;
    }

    public long getLocalDefaultExpireAfterAccessInMillis() {
        return this.localDefaultExpireAfterAccessInMillis;
    }

    public long getLocalDefaultExpireAfterWriteInMillis() {
        return this.localDefaultExpireAfterWriteInMillis;
    }

    public long getRemoteDefaultExpireAfterWriteInMillis() {
        return this.remoteDefaultExpireAfterWriteInMillis;
    }

    public String getBothCacheSyncTopic() {
        return this.bothCacheSyncTopic;
    }

    public void setHiddenPackages(String[] hiddenPackages) {
        this.hiddenPackages = hiddenPackages;
    }

    public void setStatIntervalMinutes(int statIntervalMinutes) {
        this.statIntervalMinutes = statIntervalMinutes;
    }

    public void setEnableMethodCache(boolean enableMethodCache) {
        this.enableMethodCache = enableMethodCache;
    }

    public void setKeyConvertor(String keyConvertor) {
        this.keyConvertor = keyConvertor;
    }

    public void setLocalDefaultLimit(long localDefaultLimit) {
        this.localDefaultLimit = localDefaultLimit;
    }

    public void setLocalDefaultExpireAfterAccessInMillis(long localDefaultExpireAfterAccessInMillis) {
        this.localDefaultExpireAfterAccessInMillis = localDefaultExpireAfterAccessInMillis;
    }

    public void setLocalDefaultExpireAfterWriteInMillis(long localDefaultExpireAfterWriteInMillis) {
        this.localDefaultExpireAfterWriteInMillis = localDefaultExpireAfterWriteInMillis;
    }

    public void setRemoteDefaultExpireAfterWriteInMillis(long remoteDefaultExpireAfterWriteInMillis) {
        this.remoteDefaultExpireAfterWriteInMillis = remoteDefaultExpireAfterWriteInMillis;
    }

    public void setBothCacheSyncTopic(String bothCacheSyncTopic) {
        this.bothCacheSyncTopic = bothCacheSyncTopic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HappyCacheProperties)) {
            return false;
        }
        HappyCacheProperties other = (HappyCacheProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatIntervalMinutes() != other.getStatIntervalMinutes()) {
            return false;
        }
        if (this.isEnableMethodCache() != other.isEnableMethodCache()) {
            return false;
        }
        if (this.getLocalDefaultLimit() != other.getLocalDefaultLimit()) {
            return false;
        }
        if (this.getLocalDefaultExpireAfterAccessInMillis() != other.getLocalDefaultExpireAfterAccessInMillis()) {
            return false;
        }
        if (this.getLocalDefaultExpireAfterWriteInMillis() != other.getLocalDefaultExpireAfterWriteInMillis()) {
            return false;
        }
        if (this.getRemoteDefaultExpireAfterWriteInMillis() != other.getRemoteDefaultExpireAfterWriteInMillis()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHiddenPackages(), other.getHiddenPackages())) {
            return false;
        }
        String this$keyConvertor = this.getKeyConvertor();
        String other$keyConvertor = other.getKeyConvertor();
        if (this$keyConvertor == null ? other$keyConvertor != null : !this$keyConvertor.equals(other$keyConvertor)) {
            return false;
        }
        String this$bothCacheSyncTopic = this.getBothCacheSyncTopic();
        String other$bothCacheSyncTopic = other.getBothCacheSyncTopic();
        return !(this$bothCacheSyncTopic == null ? other$bothCacheSyncTopic != null : !this$bothCacheSyncTopic.equals(other$bothCacheSyncTopic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HappyCacheProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatIntervalMinutes();
        result = result * 59 + (this.isEnableMethodCache() ? 79 : 97);
        long $localDefaultLimit = this.getLocalDefaultLimit();
        result = result * 59 + (int)($localDefaultLimit >>> 32 ^ $localDefaultLimit);
        long $localDefaultExpireAfterAccessInMillis = this.getLocalDefaultExpireAfterAccessInMillis();
        result = result * 59 + (int)($localDefaultExpireAfterAccessInMillis >>> 32 ^ $localDefaultExpireAfterAccessInMillis);
        long $localDefaultExpireAfterWriteInMillis = this.getLocalDefaultExpireAfterWriteInMillis();
        result = result * 59 + (int)($localDefaultExpireAfterWriteInMillis >>> 32 ^ $localDefaultExpireAfterWriteInMillis);
        long $remoteDefaultExpireAfterWriteInMillis = this.getRemoteDefaultExpireAfterWriteInMillis();
        result = result * 59 + (int)($remoteDefaultExpireAfterWriteInMillis >>> 32 ^ $remoteDefaultExpireAfterWriteInMillis);
        result = result * 59 + Arrays.deepHashCode(this.getHiddenPackages());
        String $keyConvertor = this.getKeyConvertor();
        result = result * 59 + ($keyConvertor == null ? 43 : $keyConvertor.hashCode());
        String $bothCacheSyncTopic = this.getBothCacheSyncTopic();
        result = result * 59 + ($bothCacheSyncTopic == null ? 43 : $bothCacheSyncTopic.hashCode());
        return result;
    }

    public String toString() {
        return "HappyCacheProperties(hiddenPackages=" + Arrays.deepToString(this.getHiddenPackages()) + ", statIntervalMinutes=" + this.getStatIntervalMinutes() + ", enableMethodCache=" + this.isEnableMethodCache() + ", keyConvertor=" + this.getKeyConvertor() + ", localDefaultLimit=" + this.getLocalDefaultLimit() + ", localDefaultExpireAfterAccessInMillis=" + this.getLocalDefaultExpireAfterAccessInMillis() + ", localDefaultExpireAfterWriteInMillis=" + this.getLocalDefaultExpireAfterWriteInMillis() + ", remoteDefaultExpireAfterWriteInMillis=" + this.getRemoteDefaultExpireAfterWriteInMillis() + ", bothCacheSyncTopic=" + this.getBothCacheSyncTopic() + ")";
    }
}

