/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.swagger;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import cool.happycoding.code.swagger.HappySwaggerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableKnife4j
@Import(value={BeanValidatorPluginsConfiguration.class})
@EnableConfigurationProperties(value={HappySwaggerProperties.class})
@ConditionalOnProperty(name={"happy.code.swagger.enable"}, matchIfMissing=true)
public class HappySwaggerAutoConfiguration {
    private final HappySwaggerProperties happySwaggerProperties;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.happySwaggerProperties.getGroup()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.happySwaggerProperties.getBasePackage())).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.happySwaggerProperties.getTitle()).description(this.happySwaggerProperties.getDescription()).termsOfServiceUrl(this.happySwaggerProperties.getServiceUrl()).version(this.happySwaggerProperties.getVersion()).contact(new Contact(this.happySwaggerProperties.getContact().getName(), this.happySwaggerProperties.getContact().getUrl(), this.happySwaggerProperties.getContact().getEmail())).build();
    }

    public HappySwaggerAutoConfiguration(HappySwaggerProperties happySwaggerProperties) {
        this.happySwaggerProperties = happySwaggerProperties;
    }
}

