/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.user.context;

import cn.hutool.core.util.ObjectUtil;
import cool.happycoding.code.base.user.User;
import cool.happycoding.code.base.user.UserDetailService;
import cool.happycoding.code.user.DefaultUser;
import cool.happycoding.code.user.UserContextProperties;
import cool.happycoding.code.user.UserInnerFilter;
import cool.happycoding.code.user.context.UserContextHolder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContextLoadInnerFilter
implements UserInnerFilter {
    private static final Logger log = LoggerFactory.getLogger(UserContextLoadInnerFilter.class);
    private final UserDetailService userContextService;
    private final UserContextProperties userContextProperties;

    public UserContextLoadInnerFilter(UserDetailService userContextService, UserContextProperties userContextProperties) {
        this.userContextService = userContextService;
        this.userContextProperties = userContextProperties;
    }

    @Override
    public void filter(HttpServletRequest request) {
        String userId = request.getHeader(this.userContextProperties.getUserIdField());
        log.warn("request header user-id:{}", (Object)userId);
        User user = this.userContextService.loadUserDetail(userId);
        if (ObjectUtil.isNull((Object)user)) {
            user = DefaultUser.defaultUser(this.userContextProperties.getDefaultUserId(), this.userContextProperties.getDefaultUserName());
        }
        UserContextHolder.setUser(user);
    }

    @Override
    public void post() {
        UserContextHolder.clear();
    }

    public int getOrder() {
        return this.userContextProperties.getFilterOrder();
    }
}

