/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.user.filter;

import com.google.common.collect.Lists;
import cool.happycoding.code.user.UserInnerFilter;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;

public class UserContextLoadFilter
implements Filter {
    private final List<UserInnerFilter> userInnerFilters;
    private final List<String> skipUrls = Lists.newArrayList();
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public UserContextLoadFilter(List<UserInnerFilter> userInnerFilters) {
        this.userInnerFilters = userInnerFilters;
        this.skipUrls.add("/happy/auth/**");
        this.skipUrls.add("/happy/captcha/**");
        this.skipUrls.add("/actuator/health/**");
        this.skipUrls.add("/doc.html");
        this.skipUrls.add("/webjars/**");
        this.skipUrls.add("/v2/api-docs/**");
        this.skipUrls.add("/swagger-resources");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String url = ((HttpServletRequest)request).getRequestURI();
        if (!this.match(url)) {
            try {
                this.userInnerFilters.forEach(userInnerFilter -> userInnerFilter.filter((HttpServletRequest)request));
                filterChain.doFilter(request, response);
            }
            finally {
                this.userInnerFilters.forEach(UserInnerFilter::post);
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private boolean match(String url) {
        return this.skipUrls.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, url));
    }
}

