/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="happy.code.web")
public class HappyWebProperties {
    public static final String HAPPY_WEB_PREFIX = "happy.code.web";
    public static final String DEFAULT_MEDIA_TYPE = "application/json";
    private Serializer serializer = new Serializer();
    private Deserializer deserializer = new Deserializer();
    private Pool pool = new Pool();
    private ConverterType converterType = ConverterType.fastjson;

    public Serializer getSerializer() {
        return this.serializer;
    }

    public Deserializer getDeserializer() {
        return this.deserializer;
    }

    public Pool getPool() {
        return this.pool;
    }

    public ConverterType getConverterType() {
        return this.converterType;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void setDeserializer(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setConverterType(ConverterType converterType) {
        this.converterType = converterType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HappyWebProperties)) {
            return false;
        }
        HappyWebProperties other = (HappyWebProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Serializer this$serializer = this.getSerializer();
        Serializer other$serializer = other.getSerializer();
        if (this$serializer == null ? other$serializer != null : !((Object)this$serializer).equals(other$serializer)) {
            return false;
        }
        Deserializer this$deserializer = this.getDeserializer();
        Deserializer other$deserializer = other.getDeserializer();
        if (this$deserializer == null ? other$deserializer != null : !((Object)this$deserializer).equals(other$deserializer)) {
            return false;
        }
        Pool this$pool = this.getPool();
        Pool other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool)) {
            return false;
        }
        ConverterType this$converterType = this.getConverterType();
        ConverterType other$converterType = other.getConverterType();
        return !(this$converterType == null ? other$converterType != null : !((Object)((Object)this$converterType)).equals((Object)other$converterType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HappyWebProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Serializer $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : ((Object)$serializer).hashCode());
        Deserializer $deserializer = this.getDeserializer();
        result = result * 59 + ($deserializer == null ? 43 : ((Object)$deserializer).hashCode());
        Pool $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
        ConverterType $converterType = this.getConverterType();
        result = result * 59 + ($converterType == null ? 43 : ((Object)((Object)$converterType)).hashCode());
        return result;
    }

    public String toString() {
        return "HappyWebProperties(serializer=" + this.getSerializer() + ", deserializer=" + this.getDeserializer() + ", pool=" + this.getPool() + ", converterType=" + (Object)((Object)this.getConverterType()) + ")";
    }

    public static class Pool {
        int corePoolSize = 10;
        int maxPoolSize = 32;
        boolean allowCoreThreadTimeOut = true;
        long keepAliveTime = 60000L;
        int queueCapacity = 512;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public boolean isAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pool)) {
                return false;
            }
            Pool other = (Pool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCorePoolSize() != other.getCorePoolSize()) {
                return false;
            }
            if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
                return false;
            }
            if (this.isAllowCoreThreadTimeOut() != other.isAllowCoreThreadTimeOut()) {
                return false;
            }
            if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
                return false;
            }
            return this.getQueueCapacity() == other.getQueueCapacity();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCorePoolSize();
            result = result * 59 + this.getMaxPoolSize();
            result = result * 59 + (this.isAllowCoreThreadTimeOut() ? 79 : 97);
            long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
            result = result * 59 + this.getQueueCapacity();
            return result;
        }

        public String toString() {
            return "HappyWebProperties.Pool(corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", allowCoreThreadTimeOut=" + this.isAllowCoreThreadTimeOut() + ", keepAliveTime=" + this.getKeepAliveTime() + ", queueCapacity=" + this.getQueueCapacity() + ")";
        }
    }

    public static enum ConverterType {
        fastjson,
        jackson2;

    }

    public static class Deserializer {
        public static final String DESERIALIZER_PREFIX = "happy.code.web.deserializer";
        private boolean enableDate = true;

        public boolean isEnableDate() {
            return this.enableDate;
        }

        public void setEnableDate(boolean enableDate) {
            this.enableDate = enableDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Deserializer)) {
                return false;
            }
            Deserializer other = (Deserializer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnableDate() == other.isEnableDate();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Deserializer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableDate() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HappyWebProperties.Deserializer(enableDate=" + this.isEnableDate() + ")";
        }
    }

    public static class Serializer {
        public static final String SERIALIZER_PREFIX = "happy.code.web.serializer";
        private boolean enableDate = true;
        private boolean enableBigDecimalAsPlain = true;
        private boolean enableLongAsPlain = true;
        private String dateFormat = "yyyy-MM-dd HH:mm:ss";

        public boolean isEnableDate() {
            return this.enableDate;
        }

        public boolean isEnableBigDecimalAsPlain() {
            return this.enableBigDecimalAsPlain;
        }

        public boolean isEnableLongAsPlain() {
            return this.enableLongAsPlain;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setEnableDate(boolean enableDate) {
            this.enableDate = enableDate;
        }

        public void setEnableBigDecimalAsPlain(boolean enableBigDecimalAsPlain) {
            this.enableBigDecimalAsPlain = enableBigDecimalAsPlain;
        }

        public void setEnableLongAsPlain(boolean enableLongAsPlain) {
            this.enableLongAsPlain = enableLongAsPlain;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Serializer)) {
                return false;
            }
            Serializer other = (Serializer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnableDate() != other.isEnableDate()) {
                return false;
            }
            if (this.isEnableBigDecimalAsPlain() != other.isEnableBigDecimalAsPlain()) {
                return false;
            }
            if (this.isEnableLongAsPlain() != other.isEnableLongAsPlain()) {
                return false;
            }
            String this$dateFormat = this.getDateFormat();
            String other$dateFormat = other.getDateFormat();
            return !(this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Serializer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableDate() ? 79 : 97);
            result = result * 59 + (this.isEnableBigDecimalAsPlain() ? 79 : 97);
            result = result * 59 + (this.isEnableLongAsPlain() ? 79 : 97);
            String $dateFormat = this.getDateFormat();
            result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
            return result;
        }

        public String toString() {
            return "HappyWebProperties.Serializer(enableDate=" + this.isEnableDate() + ", enableBigDecimalAsPlain=" + this.isEnableBigDecimalAsPlain() + ", enableLongAsPlain=" + this.isEnableLongAsPlain() + ", dateFormat=" + this.getDateFormat() + ")";
        }
    }
}

