/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.exception;

import cool.happycoding.code.base.common.ResultCode;
import cool.happycoding.code.base.result.Result;
import java.io.Serializable;
import java.util.Map;

public class ErrorDetail
implements Serializable {
    private String path;
    private Map<String, Object> error;

    public static Result error(ResultCode resultCode, String path) {
        return ErrorDetail.error(resultCode.getCode(), resultCode.getMessage(), path);
    }

    public static Result error(String code, String message, String path) {
        Result result = Result.failure((String)code, (String)message);
        result.setErrorData((Object)ErrorDetail.builder().path(path).build());
        return result;
    }

    public static Result error(ResultCode resultCode, String path, Map<String, Object> detail) {
        return ErrorDetail.error(resultCode.getCode(), resultCode.getMessage(), path, detail);
    }

    public static Result error(String code, String message, String path, Map<String, Object> detail) {
        Result result = Result.failure((String)code, (String)message);
        result.setErrorData((Object)ErrorDetail.builder().path(path).error(detail).build());
        return result;
    }

    public static ErrorDetailBuilder builder() {
        return new ErrorDetailBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, Object> getError() {
        return this.error;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setError(Map<String, Object> error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorDetail)) {
            return false;
        }
        ErrorDetail other = (ErrorDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Map<String, Object> this$error = this.getError();
        Map<String, Object> other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Map<String, Object> $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "ErrorDetail(path=" + this.getPath() + ", error=" + this.getError() + ")";
    }

    public ErrorDetail() {
    }

    public ErrorDetail(String path, Map<String, Object> error) {
        this.path = path;
        this.error = error;
    }

    public static class ErrorDetailBuilder {
        private String path;
        private Map<String, Object> error;

        ErrorDetailBuilder() {
        }

        public ErrorDetailBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ErrorDetailBuilder error(Map<String, Object> error) {
            this.error = error;
            return this;
        }

        public ErrorDetail build() {
            return new ErrorDetail(this.path, this.error);
        }

        public String toString() {
            return "ErrorDetail.ErrorDetailBuilder(path=" + this.path + ", error=" + this.error + ")";
        }
    }
}

