/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.bootstrap.writer;

import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.value.ExpressionValueVisitor;
import cool.klass.model.meta.domain.api.value.TypeMemberReferencePath;
import cool.klass.model.meta.domain.api.value.VariableReference;
import cool.klass.model.meta.domain.api.value.literal.BooleanLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.FloatingPointLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.IntegerLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.LiteralListValue;
import cool.klass.model.meta.domain.api.value.literal.NullLiteral;
import cool.klass.model.meta.domain.api.value.literal.StringLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.UserLiteral;
import java.util.Objects;
import javax.annotation.Nonnull;
import klass.model.meta.domain.ExpressionValue;
import klass.model.meta.domain.MemberReferencePath;
import klass.model.meta.domain.ThisMemberReferencePath;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;

public class BootstrapExpressionValueVisitor2
implements ExpressionValueVisitor {
    private final ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue> expressionValuesByExpressionValue;
    private final MutableList<MemberReferencePath> bootstrappedMemberReferencePaths = Lists.mutable.empty();
    private final MutableList<klass.model.meta.domain.TypeMemberReferencePath> bootstrappedTypeMemberReferencePaths = Lists.mutable.empty();
    private final MutableList<ThisMemberReferencePath> bootstrappedThisMemberReferencePaths = Lists.mutable.empty();

    public BootstrapExpressionValueVisitor2(ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue> expressionValuesByExpressionValue) {
        this.expressionValuesByExpressionValue = Objects.requireNonNull(expressionValuesByExpressionValue);
    }

    public MutableList<MemberReferencePath> getBootstrappedMemberReferencePaths() {
        return this.bootstrappedMemberReferencePaths;
    }

    public MutableList<klass.model.meta.domain.TypeMemberReferencePath> getBootstrappedTypeMemberReferencePaths() {
        return this.bootstrappedTypeMemberReferencePaths;
    }

    public MutableList<ThisMemberReferencePath> getBootstrappedThisMemberReferencePaths() {
        return this.bootstrappedThisMemberReferencePaths;
    }

    public void visitTypeMember(@Nonnull TypeMemberReferencePath typeMemberExpressionValue) {
        ExpressionValue bootstrappedExpressionValue = (ExpressionValue)this.expressionValuesByExpressionValue.get((Object)typeMemberExpressionValue);
        Klass klass = typeMemberExpressionValue.getKlass();
        DataTypeProperty property = typeMemberExpressionValue.getProperty();
        MemberReferencePath bootstrappedMemberReferencePath = new MemberReferencePath();
        this.bootstrappedMemberReferencePaths.add((Object)bootstrappedMemberReferencePath);
        bootstrappedMemberReferencePath.setId(bootstrappedExpressionValue.getId());
        bootstrappedMemberReferencePath.setClassName(klass.getName());
        bootstrappedMemberReferencePath.setPropertyClassName(property.getOwningClassifier().getName());
        bootstrappedMemberReferencePath.setPropertyName(property.getName());
        klass.model.meta.domain.TypeMemberReferencePath bootstrappedTypeMemberReferencePath = new klass.model.meta.domain.TypeMemberReferencePath();
        this.bootstrappedTypeMemberReferencePaths.add((Object)bootstrappedTypeMemberReferencePath);
        bootstrappedTypeMemberReferencePath.setId(bootstrappedExpressionValue.getId());
        if (typeMemberExpressionValue.getAssociationEnds().notEmpty()) {
            throw new AssertionError((Object)"TODO");
        }
    }

    public void visitThisMember(@Nonnull cool.klass.model.meta.domain.api.value.ThisMemberReferencePath thisMemberExpressionValue) {
        ExpressionValue bootstrappedExpressionValue = (ExpressionValue)this.expressionValuesByExpressionValue.get((Object)thisMemberExpressionValue);
        Klass klass = thisMemberExpressionValue.getKlass();
        DataTypeProperty property = thisMemberExpressionValue.getProperty();
        MemberReferencePath bootstrappedMemberReferencePath = new MemberReferencePath();
        this.bootstrappedMemberReferencePaths.add((Object)bootstrappedMemberReferencePath);
        bootstrappedMemberReferencePath.setId(bootstrappedExpressionValue.getId());
        bootstrappedMemberReferencePath.setClassName(klass.getName());
        bootstrappedMemberReferencePath.setPropertyClassName(property.getOwningClassifier().getName());
        bootstrappedMemberReferencePath.setPropertyName(property.getName());
        ThisMemberReferencePath bootstrappedThisMemberReferencePath = new ThisMemberReferencePath();
        this.bootstrappedThisMemberReferencePaths.add((Object)bootstrappedThisMemberReferencePath);
        bootstrappedThisMemberReferencePath.setId(bootstrappedExpressionValue.getId());
        if (thisMemberExpressionValue.getAssociationEnds().notEmpty()) {
            throw new AssertionError((Object)"TODO");
        }
    }

    public void visitVariableReference(@Nonnull VariableReference variableReference) {
        ExpressionValue bootstrappedExpressionValue = (ExpressionValue)this.expressionValuesByExpressionValue.get((Object)variableReference);
        klass.model.meta.domain.VariableReference bootstrappedVariableReference = new klass.model.meta.domain.VariableReference();
        bootstrappedVariableReference.setId(bootstrappedExpressionValue.getId());
    }

    public void visitBooleanLiteral(@Nonnull BooleanLiteralValue booleanLiteralValue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitBooleanLiteral() not implemented yet");
    }

    public void visitIntegerLiteral(@Nonnull IntegerLiteralValue integerLiteralValue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitIntegerLiteral() not implemented yet");
    }

    public void visitFloatingPointLiteral(@Nonnull FloatingPointLiteralValue floatingPointLiteralValue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitFloatingPointLiteral() not implemented yet");
    }

    public void visitStringLiteral(@Nonnull StringLiteralValue stringLiteralValue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitStringLiteral() not implemented yet");
    }

    public void visitLiteralList(@Nonnull LiteralListValue literalListValue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitLiteralList() not implemented yet");
    }

    public void visitUserLiteral(@Nonnull UserLiteral userLiteral) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitUserLiteral() not implemented yet");
    }

    public void visitNullLiteral(@Nonnull NullLiteral nullLiteral) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitNullLiteral() not implemented yet");
    }
}

