/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.bootstrap.writer;

import cool.klass.data.store.DataStore;
import cool.klass.model.converter.bootstrap.writer.BootstrapCriteriaVisitor1;
import cool.klass.model.converter.bootstrap.writer.BootstrapCriteriaVisitor2;
import cool.klass.model.converter.bootstrap.writer.BootstrapExpressionValueCriteriaVisitor;
import cool.klass.model.converter.bootstrap.writer.BootstrapExpressionValueVisitor1;
import cool.klass.model.converter.bootstrap.writer.BootstrapExpressionValueVisitor2;
import cool.klass.model.converter.bootstrap.writer.BootstrapExpressionValueVisitor3;
import cool.klass.model.meta.domain.api.DataType;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.PackageableElement;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.criteria.CriteriaVisitor;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.order.OrderByMemberReferencePath;
import cool.klass.model.meta.domain.api.projection.Projection;
import cool.klass.model.meta.domain.api.projection.ProjectionChild;
import cool.klass.model.meta.domain.api.projection.ProjectionDataTypeProperty;
import cool.klass.model.meta.domain.api.projection.ProjectionProjectionReference;
import cool.klass.model.meta.domain.api.projection.ProjectionVisitor;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.model.meta.domain.api.service.Service;
import cool.klass.model.meta.domain.api.service.ServiceGroup;
import cool.klass.model.meta.domain.api.service.ServiceProjectionDispatch;
import cool.klass.model.meta.domain.api.service.url.Url;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import klass.model.meta.domain.Association;
import klass.model.meta.domain.AssociationEndList;
import klass.model.meta.domain.AssociationEndModifier;
import klass.model.meta.domain.AssociationEndModifierList;
import klass.model.meta.domain.AssociationEndOrderBy;
import klass.model.meta.domain.AssociationEndOrderByList;
import klass.model.meta.domain.AssociationList;
import klass.model.meta.domain.Classifier;
import klass.model.meta.domain.ClassifierInterfaceMapping;
import klass.model.meta.domain.ClassifierInterfaceMappingList;
import klass.model.meta.domain.ClassifierList;
import klass.model.meta.domain.ClassifierModifier;
import klass.model.meta.domain.ClassifierModifierList;
import klass.model.meta.domain.Criteria;
import klass.model.meta.domain.DataTypeProperty;
import klass.model.meta.domain.DataTypePropertyList;
import klass.model.meta.domain.EnumerationList;
import klass.model.meta.domain.EnumerationLiteral;
import klass.model.meta.domain.EnumerationLiteralList;
import klass.model.meta.domain.EnumerationParameter;
import klass.model.meta.domain.EnumerationParameterList;
import klass.model.meta.domain.EnumerationProperty;
import klass.model.meta.domain.EnumerationPropertyList;
import klass.model.meta.domain.ExpressionValue;
import klass.model.meta.domain.Interface;
import klass.model.meta.domain.InterfaceList;
import klass.model.meta.domain.Klass;
import klass.model.meta.domain.KlassList;
import klass.model.meta.domain.MaxLengthPropertyValidation;
import klass.model.meta.domain.MaxLengthPropertyValidationList;
import klass.model.meta.domain.MaxPropertyValidation;
import klass.model.meta.domain.MaxPropertyValidationList;
import klass.model.meta.domain.MemberReferencePath;
import klass.model.meta.domain.MemberReferencePathList;
import klass.model.meta.domain.MinLengthPropertyValidation;
import klass.model.meta.domain.MinLengthPropertyValidationList;
import klass.model.meta.domain.MinPropertyValidation;
import klass.model.meta.domain.MinPropertyValidationList;
import klass.model.meta.domain.NamedElementAbstract;
import klass.model.meta.domain.NamedProjection;
import klass.model.meta.domain.NamedProjectionList;
import klass.model.meta.domain.PackageableElementList;
import klass.model.meta.domain.Parameter;
import klass.model.meta.domain.PrimitiveParameter;
import klass.model.meta.domain.PrimitiveParameterList;
import klass.model.meta.domain.PrimitivePropertyList;
import klass.model.meta.domain.ProjectionElement;
import klass.model.meta.domain.ProjectionElementList;
import klass.model.meta.domain.ProjectionReferenceProperty;
import klass.model.meta.domain.ProjectionWithAssociationEnd;
import klass.model.meta.domain.PropertyModifier;
import klass.model.meta.domain.PropertyModifierList;
import klass.model.meta.domain.RootProjection;
import klass.model.meta.domain.RootProjectionList;
import klass.model.meta.domain.ServiceGroupList;
import klass.model.meta.domain.ServiceList;
import klass.model.meta.domain.ThisMemberReferencePath;
import klass.model.meta.domain.ThisMemberReferencePathList;
import klass.model.meta.domain.TypeMemberReferencePathList;
import klass.model.meta.domain.UrlList;
import klass.model.meta.domain.UrlParameter;
import klass.model.meta.domain.UrlParameterList;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;

public class KlassBootstrapWriter {
    private final DomainModel domainModel;
    private final DataStore dataStore;

    public KlassBootstrapWriter(DomainModel domainModel, DataStore dataStore) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
    }

    public void bootstrapMetaModel() {
        this.dataStore.runInTransaction(this::bootstrapMetaModelInTransaction);
    }

    private void bootstrapMetaModelInTransaction() {
        ((PackageableElementList)this.domainModel.getTopLevelElements().collect(this::handlePackageableElement, (Collection)new PackageableElementList())).insertAll();
        ((EnumerationList)this.domainModel.getEnumerations().collect(this::handleEnumeration, (Collection)new EnumerationList())).insertAll();
        ((EnumerationLiteralList)this.domainModel.getEnumerations().flatCollect(Enumeration::getEnumerationLiterals).collect(this::handleEnumerationLiteral, (Collection)new EnumerationLiteralList())).insertAll();
        ((ClassifierList)this.domainModel.getClassifiers().collect(this::handleClassifier, (Collection)new ClassifierList())).insertAll();
        ((InterfaceList)this.domainModel.getInterfaces().collect(this::handleInterface, (Collection)new InterfaceList())).insertAll();
        ((KlassList)this.domainModel.getClasses().collect(this::handleClass, (Collection)new KlassList())).insertAll();
        ((ClassifierInterfaceMappingList)this.domainModel.getClassifiers().flatCollect(this::handleSuperInterface, (Collection)new ClassifierInterfaceMappingList())).insertAll();
        ((ClassifierModifierList)this.domainModel.getClassifiers().flatCollect(this::handleClassifierModifier, (Collection)new ClassifierModifierList())).insertAll();
        ((DataTypePropertyList)this.domainModel.getClassifiers().flatCollect(this::handleDataTypeProperty, (Collection)new DataTypePropertyList())).insertAll();
        ImmutableList allDataTypeProperties = this.domainModel.getClassifiers().flatCollect(cool.klass.model.meta.domain.api.Classifier::getDeclaredDataTypeProperties);
        ((PropertyModifierList)allDataTypeProperties.flatCollect(this::handlePropertyModifier, (Collection)new PropertyModifierList())).insertAll();
        ((MinLengthPropertyValidationList)allDataTypeProperties.collect(this::handleMinLengthPropertyValidation).reject(Optional::isEmpty).collect(Optional::get, (Collection)new MinLengthPropertyValidationList())).insertAll();
        ((MaxLengthPropertyValidationList)allDataTypeProperties.collect(this::handleMaxLengthPropertyValidation).reject(Optional::isEmpty).collect(Optional::get, (Collection)new MaxLengthPropertyValidationList())).insertAll();
        ((MinPropertyValidationList)allDataTypeProperties.collect(this::handleMinPropertyValidation).reject(Optional::isEmpty).collect(Optional::get, (Collection)new MinPropertyValidationList())).insertAll();
        ((MaxPropertyValidationList)allDataTypeProperties.collect(this::handleMaxPropertyValidation).reject(Optional::isEmpty).collect(Optional::get, (Collection)new MaxPropertyValidationList())).insertAll();
        ((PrimitivePropertyList)allDataTypeProperties.select(PrimitiveProperty.class::isInstance).collect(PrimitiveProperty.class::cast).collect(this::handlePrimitiveProperty, (Collection)new PrimitivePropertyList())).insertAll();
        ((EnumerationPropertyList)allDataTypeProperties.select(cool.klass.model.meta.domain.api.property.EnumerationProperty.class::isInstance).collect(cool.klass.model.meta.domain.api.property.EnumerationProperty.class::cast).collect(this::handleEnumerationProperty, (Collection)new EnumerationPropertyList())).insertAll();
        ImmutableList urls = this.domainModel.getServiceGroups().flatCollect(ServiceGroup::getUrls);
        ImmutableList services = urls.flatCollect(Url::getServices);
        ImmutableList serviceCriteria = services.flatCollect((Function & Serializable)each -> Lists.immutable.with((Object)each.getQueryCriteria(), (Object)each.getAuthorizeCriteria(), (Object)each.getValidateCriteria(), (Object)each.getConflictCriteria())).reject(Optional::isEmpty).collect(Optional::get);
        ImmutableList associationCriteria = this.domainModel.getAssociations().collect(cool.klass.model.meta.domain.api.Association::getCriteria);
        ImmutableList allCriteria = associationCriteria.newWithAll((Iterable)serviceCriteria);
        ImmutableList associationEnds = this.domainModel.getAssociations().flatCollect(cool.klass.model.meta.domain.api.Association::getAssociationEnds);
        ImmutableList orderByReferencePaths = associationEnds.collect(ReferenceProperty::getOrderBy).reject(Optional::isEmpty).collect(Optional::get).flatCollect(OrderBy::getOrderByMemberReferencePaths).collect(OrderByMemberReferencePath::getThisMemberReferencePath);
        BootstrapExpressionValueVisitor1 expressionValueVisitor1 = new BootstrapExpressionValueVisitor1();
        BootstrapExpressionValueCriteriaVisitor criteriaVisitor1 = new BootstrapExpressionValueCriteriaVisitor(expressionValueVisitor1);
        allCriteria.each((Procedure & Serializable)criteria -> criteria.visit((CriteriaVisitor)criteriaVisitor1));
        orderByReferencePaths.each(expressionValueVisitor1::visitThisMember);
        expressionValueVisitor1.getBootstrappedExpressionValues().insertAll();
        ImmutableMap expressionValuesByExpressionValue = expressionValueVisitor1.getExpressionValuesByExpressionValue().toImmutable();
        BootstrapExpressionValueVisitor2 expressionValueVisitor2 = new BootstrapExpressionValueVisitor2((ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue>)expressionValuesByExpressionValue);
        BootstrapExpressionValueCriteriaVisitor criteriaVisitor2 = new BootstrapExpressionValueCriteriaVisitor(expressionValueVisitor2);
        allCriteria.each((Procedure & Serializable)criteria -> criteria.visit((CriteriaVisitor)criteriaVisitor2));
        orderByReferencePaths.each(expressionValueVisitor2::visitThisMember);
        new MemberReferencePathList(expressionValueVisitor2.getBootstrappedMemberReferencePaths()).insertAll();
        new ThisMemberReferencePathList(expressionValueVisitor2.getBootstrappedThisMemberReferencePaths()).insertAll();
        new TypeMemberReferencePathList(expressionValueVisitor2.getBootstrappedTypeMemberReferencePaths()).insertAll();
        BootstrapCriteriaVisitor1 criteriaVisitor3 = new BootstrapCriteriaVisitor1();
        allCriteria.each((Procedure & Serializable)criteria -> criteria.visit((CriteriaVisitor)criteriaVisitor3));
        criteriaVisitor3.getBootstrappedCriteria().insertAll();
        ImmutableMap<cool.klass.model.meta.domain.api.criteria.Criteria, Criteria> criteriaByCriteria = criteriaVisitor3.getCriteriaByCriteria();
        BootstrapCriteriaVisitor2 criteriaVisitor4 = new BootstrapCriteriaVisitor2(criteriaByCriteria, (ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue>)expressionValuesByExpressionValue);
        allCriteria.each((Procedure & Serializable)criteria -> criteria.visit((CriteriaVisitor)criteriaVisitor4));
        criteriaVisitor4.getAllCriteria().insertAll();
        criteriaVisitor4.getEdgePointCriteria().insertAll();
        criteriaVisitor4.getOperatorCriteria().insertAll();
        criteriaVisitor4.getBinaryCriteria().insertAll();
        criteriaVisitor4.getAndCriteria().insertAll();
        criteriaVisitor4.getOrCriteria().insertAll();
        ((AssociationList)this.domainModel.getAssociations().collectWith(this::handleAssociation, criteriaByCriteria, (Collection)new AssociationList())).insertAll();
        ((AssociationEndList)associationEnds.collect(this::handleAssociationEnd, (Collection)new AssociationEndList())).insertAll();
        ((AssociationEndModifierList)associationEnds.flatCollect((Function & Serializable)associationEnd -> associationEnd.getModifiers().collectWith(this::handleAssociationEndModifier, associationEnd), (Collection)new AssociationEndModifierList())).insertAll();
        ((AssociationEndOrderByList)associationEnds.flatCollect((Function & Serializable)associationEnd -> associationEnd.getOrderBy().map(OrderBy::getOrderByMemberReferencePaths).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty()).collect((Function & Serializable)memberReferencePath -> this.handleOrderByMemberReferencePath((OrderByMemberReferencePath)memberReferencePath, (AssociationEnd)associationEnd, (ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue>)expressionValuesByExpressionValue)), (Collection)new AssociationEndOrderByList())).insertAll();
        MutableMap rootProjectionByProjection = Maps.mutable.empty();
        ProjectionElementList projectionElementList = new ProjectionElementList();
        for (Projection projection2 : this.domainModel.getProjections()) {
            ProjectionElement projectionElement = this.handleRootProjectionElement(projection2);
            rootProjectionByProjection.put((Object)projection2, (Object)projectionElement);
            projectionElementList.add((Object)projectionElement);
        }
        projectionElementList.insertAll();
        ((RootProjectionList)this.domainModel.getProjections().collect((Function & Serializable)each -> this.handleRootProjection((Projection)each, (ProjectionElement)rootProjectionByProjection.get(each)), (Collection)new RootProjectionList())).insertAll();
        ((NamedProjectionList)this.domainModel.getProjections().collect((Function & Serializable)projection -> this.handleNamedProjection((Projection)projection, (MutableMap<Projection, ProjectionElement>)rootProjectionByProjection), (Collection)new NamedProjectionList())).insertAll();
        this.domainModel.getProjections().each((Procedure & Serializable)projection -> this.handleProjectionChildren((Projection)projection, (ProjectionElement)rootProjectionByProjection.get(projection)));
        ((ServiceGroupList)this.domainModel.getServiceGroups().collect(this::handleServiceGroup, (Collection)new ServiceGroupList())).insertAll();
        ((UrlList)urls.collect(this::handleUrl, (Collection)new UrlList())).insertAll();
        MutableMap bootstrappedParametersByParameter = Maps.mutable.empty();
        ((UrlParameterList)urls.flatCollect((Function & Serializable)url -> url.getPathParameters().collect((Function & Serializable)eachPathParameter -> this.handleUrlParameter((Url)url, (cool.klass.model.meta.domain.api.parameter.Parameter)eachPathParameter, "path", (MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter>)bootstrappedParametersByParameter)), (Collection)new UrlParameterList())).insertAll();
        ((UrlParameterList)urls.flatCollect((Function & Serializable)url -> url.getQueryParameters().collect((Function & Serializable)eachPathParameter -> this.handleUrlParameter((Url)url, (cool.klass.model.meta.domain.api.parameter.Parameter)eachPathParameter, "query", (MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter>)bootstrappedParametersByParameter)), (Collection)new UrlParameterList())).insertAll();
        ImmutableList parameters = urls.flatCollect(Url::getParameters);
        ((PrimitiveParameterList)parameters.select((Predicate & Serializable)each -> each.getType() instanceof PrimitiveType).collect((Function & Serializable)each -> this.handleUrlPrimitiveParameter((cool.klass.model.meta.domain.api.parameter.Parameter)each, (MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter>)bootstrappedParametersByParameter), (Collection)new PrimitiveParameterList())).insertAll();
        ((EnumerationParameterList)parameters.select((Predicate & Serializable)each -> each.getType() instanceof Enumeration).collect((Function & Serializable)each -> this.handleUrlEnumerationParameter((cool.klass.model.meta.domain.api.parameter.Parameter)each, (MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter>)bootstrappedParametersByParameter), (Collection)new EnumerationParameterList())).insertAll();
        BootstrapExpressionValueVisitor3 expressionValueVisitor3 = new BootstrapExpressionValueVisitor3((ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue>)expressionValuesByExpressionValue, (ImmutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter>)bootstrappedParametersByParameter.toImmutable());
        BootstrapExpressionValueCriteriaVisitor criteriaVisitor5 = new BootstrapExpressionValueCriteriaVisitor(expressionValueVisitor3);
        serviceCriteria.each((Procedure & Serializable)criteria -> criteria.visit((CriteriaVisitor)criteriaVisitor5));
        ((ServiceList)services.collectWith(this::handleService, criteriaByCriteria, (Collection)new ServiceList())).insertAll();
    }

    private klass.model.meta.domain.PackageableElement handlePackageableElement(@Nonnull PackageableElement packageableElement) {
        klass.model.meta.domain.PackageableElement bootstrappedPackageableElement = new klass.model.meta.domain.PackageableElement();
        KlassBootstrapWriter.handleNamedElement((NamedElementAbstract)bootstrappedPackageableElement, (NamedElement)packageableElement);
        bootstrappedPackageableElement.setPackageName(packageableElement.getPackageName());
        return bootstrappedPackageableElement;
    }

    private klass.model.meta.domain.Enumeration handleEnumeration(@Nonnull Enumeration enumeration) {
        klass.model.meta.domain.Enumeration bootstrappedEnumeration = new klass.model.meta.domain.Enumeration();
        bootstrappedEnumeration.setName(enumeration.getName());
        return bootstrappedEnumeration;
    }

    private EnumerationLiteral handleEnumerationLiteral(@Nonnull cool.klass.model.meta.domain.api.EnumerationLiteral enumerationLiteral) {
        EnumerationLiteral bootstrappedEnumerationLiteral = new EnumerationLiteral();
        KlassBootstrapWriter.handleNamedElement((NamedElementAbstract)bootstrappedEnumerationLiteral, (NamedElement)enumerationLiteral);
        enumerationLiteral.getDeclaredPrettyName().ifPresent(arg_0 -> ((EnumerationLiteral)bootstrappedEnumerationLiteral).setPrettyName(arg_0));
        bootstrappedEnumerationLiteral.setEnumerationName(enumerationLiteral.getType().getName());
        return bootstrappedEnumerationLiteral;
    }

    private Classifier handleClassifier(@Nonnull cool.klass.model.meta.domain.api.Classifier classifier) {
        Classifier bootstrappedClassifier = new Classifier();
        bootstrappedClassifier.setName(classifier.getName());
        return bootstrappedClassifier;
    }

    private ImmutableList<ClassifierInterfaceMapping> handleSuperInterface(@Nonnull cool.klass.model.meta.domain.api.Classifier classifier) {
        return classifier.getInterfaces().collect((Function & Serializable)superInterface -> KlassBootstrapWriter.getClassifierInterfaceMapping(classifier, superInterface));
    }

    @Nonnull
    private static ClassifierInterfaceMapping getClassifierInterfaceMapping(@Nonnull cool.klass.model.meta.domain.api.Classifier classifier, cool.klass.model.meta.domain.api.Interface superInterface) {
        ClassifierInterfaceMapping classifierInterfaceMapping = new ClassifierInterfaceMapping();
        classifierInterfaceMapping.setClassifierName(classifier.getName());
        classifierInterfaceMapping.setInterfaceName(superInterface.getName());
        return classifierInterfaceMapping;
    }

    private ImmutableList<ClassifierModifier> handleClassifierModifier(@Nonnull cool.klass.model.meta.domain.api.Classifier classifier) {
        return classifier.getModifiers().collect((Function & Serializable)modifier -> this.getClassifierModifier(classifier, (Modifier)modifier));
    }

    private ClassifierModifier getClassifierModifier(cool.klass.model.meta.domain.api.Classifier classifier, Modifier modifier) {
        ClassifierModifier bootstrappedClassifierModifier = new ClassifierModifier();
        bootstrappedClassifierModifier.setKeyword(modifier.getKeyword());
        bootstrappedClassifierModifier.setOrdinal(modifier.getOrdinal());
        bootstrappedClassifierModifier.setClassifierName(classifier.getName());
        return bootstrappedClassifierModifier;
    }

    private ImmutableList<DataTypeProperty> handleDataTypeProperty(@Nonnull cool.klass.model.meta.domain.api.Classifier classifier) {
        return classifier.getDeclaredDataTypeProperties().collect(this::getDataTypeProperty);
    }

    private DataTypeProperty getDataTypeProperty(cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty) {
        cool.klass.model.meta.domain.api.Classifier classifier = dataTypeProperty.getOwningClassifier();
        DataTypeProperty bootstrappedDataTypeProperty = new DataTypeProperty();
        bootstrappedDataTypeProperty.setName(dataTypeProperty.getName());
        bootstrappedDataTypeProperty.setOrdinal(dataTypeProperty.getOrdinal());
        bootstrappedDataTypeProperty.setClassifierName(classifier.getName());
        bootstrappedDataTypeProperty.setOptional(dataTypeProperty.isOptional());
        return bootstrappedDataTypeProperty;
    }

    private ImmutableList<PropertyModifier> handlePropertyModifier(@Nonnull cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getModifiers().collect((Function & Serializable)modifier -> this.getPropertyModifier(dataTypeProperty, (Modifier)modifier));
    }

    private PropertyModifier getPropertyModifier(cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty, Modifier modifier) {
        PropertyModifier bootstrappedPropertyModifier = new PropertyModifier();
        bootstrappedPropertyModifier.setKeyword(modifier.getKeyword());
        bootstrappedPropertyModifier.setOrdinal(modifier.getOrdinal());
        bootstrappedPropertyModifier.setClassifierName(dataTypeProperty.getOwningClassifier().getName());
        bootstrappedPropertyModifier.setPropertyName(dataTypeProperty.getName());
        return bootstrappedPropertyModifier;
    }

    private Optional<MinLengthPropertyValidation> handleMinLengthPropertyValidation(cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getMinLengthPropertyValidation().map(validation -> {
            cool.klass.model.meta.domain.api.Classifier classifier = dataTypeProperty.getOwningClassifier();
            MinLengthPropertyValidation bootstrappedMinLengthPropertyValidation = new MinLengthPropertyValidation();
            bootstrappedMinLengthPropertyValidation.setClassifierName(classifier.getName());
            bootstrappedMinLengthPropertyValidation.setPropertyName(dataTypeProperty.getName());
            bootstrappedMinLengthPropertyValidation.setNumber(validation.getNumber());
            return bootstrappedMinLengthPropertyValidation;
        });
    }

    private Optional<MaxLengthPropertyValidation> handleMaxLengthPropertyValidation(cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getMaxLengthPropertyValidation().map(validation -> {
            cool.klass.model.meta.domain.api.Classifier classifier = dataTypeProperty.getOwningClassifier();
            MaxLengthPropertyValidation bootstrappedMaxLengthPropertyValidation = new MaxLengthPropertyValidation();
            bootstrappedMaxLengthPropertyValidation.setClassifierName(classifier.getName());
            bootstrappedMaxLengthPropertyValidation.setPropertyName(dataTypeProperty.getName());
            bootstrappedMaxLengthPropertyValidation.setNumber(validation.getNumber());
            return bootstrappedMaxLengthPropertyValidation;
        });
    }

    private Optional<MinPropertyValidation> handleMinPropertyValidation(cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getMinPropertyValidation().map(validation -> {
            cool.klass.model.meta.domain.api.Classifier classifier = dataTypeProperty.getOwningClassifier();
            MinPropertyValidation bootstrappedMinPropertyValidation = new MinPropertyValidation();
            bootstrappedMinPropertyValidation.setClassifierName(classifier.getName());
            bootstrappedMinPropertyValidation.setPropertyName(dataTypeProperty.getName());
            bootstrappedMinPropertyValidation.setNumber(validation.getNumber());
            return bootstrappedMinPropertyValidation;
        });
    }

    private Optional<MaxPropertyValidation> handleMaxPropertyValidation(cool.klass.model.meta.domain.api.property.DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getMaxPropertyValidation().map(validation -> {
            cool.klass.model.meta.domain.api.Classifier classifier = dataTypeProperty.getOwningClassifier();
            MaxPropertyValidation bootstrappedMaxPropertyValidation = new MaxPropertyValidation();
            bootstrappedMaxPropertyValidation.setClassifierName(classifier.getName());
            bootstrappedMaxPropertyValidation.setPropertyName(dataTypeProperty.getName());
            bootstrappedMaxPropertyValidation.setNumber(validation.getNumber());
            return bootstrappedMaxPropertyValidation;
        });
    }

    private klass.model.meta.domain.PrimitiveProperty handlePrimitiveProperty(PrimitiveProperty primitiveProperty) {
        cool.klass.model.meta.domain.api.Classifier classifier = primitiveProperty.getOwningClassifier();
        klass.model.meta.domain.PrimitiveProperty bootstrappedPrimitiveProperty = new klass.model.meta.domain.PrimitiveProperty();
        bootstrappedPrimitiveProperty.setClassifierName(classifier.getName());
        bootstrappedPrimitiveProperty.setName(primitiveProperty.getName());
        bootstrappedPrimitiveProperty.setPrimitiveType(primitiveProperty.getType().getPrettyName());
        return bootstrappedPrimitiveProperty;
    }

    private EnumerationProperty handleEnumerationProperty(cool.klass.model.meta.domain.api.property.EnumerationProperty enumerationProperty) {
        cool.klass.model.meta.domain.api.Classifier classifier = enumerationProperty.getOwningClassifier();
        EnumerationProperty bootstrappedEnumerationProperty = new EnumerationProperty();
        bootstrappedEnumerationProperty.setClassifierName(classifier.getName());
        bootstrappedEnumerationProperty.setName(enumerationProperty.getName());
        bootstrappedEnumerationProperty.setEnumerationName(enumerationProperty.getType().getName());
        return bootstrappedEnumerationProperty;
    }

    private Interface handleInterface(@Nonnull cool.klass.model.meta.domain.api.Interface anInterface) {
        Interface bootstrappedInterface = new Interface();
        bootstrappedInterface.setName(anInterface.getName());
        return bootstrappedInterface;
    }

    private Klass handleClass(@Nonnull cool.klass.model.meta.domain.api.Klass klass) {
        Klass bootstrappedClass = new Klass();
        bootstrappedClass.setName(klass.getName());
        bootstrappedClass.setAbstractClass(klass.isAbstract());
        klass.getSuperClass().map(NamedElement::getName).ifPresent(arg_0 -> ((Klass)bootstrappedClass).setSuperClassName(arg_0));
        return bootstrappedClass;
    }

    private Association handleAssociation(@Nonnull cool.klass.model.meta.domain.api.Association association, @Nonnull ImmutableMap<cool.klass.model.meta.domain.api.criteria.Criteria, Criteria> criteriaByCriteria) {
        Criteria bootstrappedCriteria = (Criteria)criteriaByCriteria.get((Object)association.getCriteria());
        Association bootstrappedAssociation = new Association();
        bootstrappedAssociation.setName(association.getName());
        bootstrappedAssociation.setCriteria(bootstrappedCriteria);
        return bootstrappedAssociation;
    }

    private klass.model.meta.domain.AssociationEnd handleAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        String direction = KlassBootstrapWriter.getDirection(associationEnd);
        klass.model.meta.domain.AssociationEnd bootstrappedAssociationEnd = new klass.model.meta.domain.AssociationEnd();
        KlassBootstrapWriter.handleNamedElement((NamedElementAbstract)bootstrappedAssociationEnd, (NamedElement)associationEnd);
        bootstrappedAssociationEnd.setOwningClassName(associationEnd.getOwningClassifier().getName());
        bootstrappedAssociationEnd.setAssociationName(associationEnd.getOwningAssociation().getName());
        bootstrappedAssociationEnd.setDirection(direction);
        bootstrappedAssociationEnd.setMultiplicity(associationEnd.getMultiplicity().getPrettyName());
        bootstrappedAssociationEnd.setResultTypeName(associationEnd.getType().getName());
        return bootstrappedAssociationEnd;
    }

    private AssociationEndModifier handleAssociationEndModifier(@Nonnull Modifier modifier, @Nonnull AssociationEnd associationEnd) {
        AssociationEndModifier bootstrappedAssociationEndModifier = new AssociationEndModifier();
        bootstrappedAssociationEndModifier.setOwningClassName(associationEnd.getOwningClassifier().getName());
        bootstrappedAssociationEndModifier.setAssociationEndName(associationEnd.getName());
        bootstrappedAssociationEndModifier.setKeyword(modifier.getKeyword());
        bootstrappedAssociationEndModifier.setOrdinal(modifier.getOrdinal());
        return bootstrappedAssociationEndModifier;
    }

    @Nonnull
    private AssociationEndOrderBy handleOrderByMemberReferencePath(@Nonnull OrderByMemberReferencePath orderByMemberReferencePath, @Nonnull AssociationEnd associationEnd, @Nonnull ImmutableMap<cool.klass.model.meta.domain.api.value.ExpressionValue, ExpressionValue> expressionValuesByExpressionValue) {
        cool.klass.model.meta.domain.api.value.ThisMemberReferencePath thisMemberReferencePath = orderByMemberReferencePath.getThisMemberReferencePath();
        ExpressionValue expressionValue = (ExpressionValue)expressionValuesByExpressionValue.get((Object)thisMemberReferencePath);
        AssociationEndOrderBy associationEndOrderBy = new AssociationEndOrderBy();
        associationEndOrderBy.setAssociationEndClassName(associationEnd.getOwningClassifier().getName());
        associationEndOrderBy.setAssociationEndName(associationEnd.getName());
        associationEndOrderBy.setThisMemberReferencePathId(expressionValue.getId());
        associationEndOrderBy.setOrderByDirection(orderByMemberReferencePath.getOrderByDirectionDeclaration().getOrderByDirection().getPrettyName());
        return associationEndOrderBy;
    }

    private void bootstrapAssociationEndOrderBy(@Nonnull AssociationEnd associationEnd, @Nonnull OrderBy orderBy) {
        for (OrderByMemberReferencePath orderByMemberReferencePath : orderBy.getOrderByMemberReferencePaths()) {
            cool.klass.model.meta.domain.api.value.ThisMemberReferencePath thisMemberReferencePath = orderByMemberReferencePath.getThisMemberReferencePath();
            ThisMemberReferencePath bootstrappedThisMemberReferencePath = this.bootstrapThisMemberReferencePath(thisMemberReferencePath);
            AssociationEndOrderBy associationEndOrderBy = new AssociationEndOrderBy();
            associationEndOrderBy.setAssociationEndClassName(associationEnd.getOwningClassifier().getName());
            associationEndOrderBy.setAssociationEndName(associationEnd.getName());
            associationEndOrderBy.setThisMemberReferencePathId(bootstrappedThisMemberReferencePath.getId());
            associationEndOrderBy.setOrderByDirection(orderByMemberReferencePath.getOrderByDirectionDeclaration().getOrderByDirection().getPrettyName());
            associationEndOrderBy.insert();
        }
    }

    @Nonnull
    private static String getDirection(@Nonnull AssociationEnd associationEnd) {
        if (associationEnd == associationEnd.getOwningAssociation().getSourceAssociationEnd()) {
            return "source";
        }
        if (associationEnd == associationEnd.getOwningAssociation().getTargetAssociationEnd()) {
            return "target";
        }
        throw new AssertionError();
    }

    private ProjectionElement handleRootProjectionElement(@Nonnull Projection projection) {
        ProjectionElement bootstrappedProjectionElement = new ProjectionElement();
        bootstrappedProjectionElement.setName(projection.getName());
        bootstrappedProjectionElement.setOrdinal(projection.getOrdinal());
        return bootstrappedProjectionElement;
    }

    private RootProjection handleRootProjection(@Nonnull Projection projection, @Nonnull ProjectionElement projectionElement) {
        RootProjection bootstrappedRootProjection = new RootProjection();
        bootstrappedRootProjection.setId(projectionElement.getId());
        bootstrappedRootProjection.setClassifierName(projection.getClassifier().getName());
        return bootstrappedRootProjection;
    }

    private void handleProjectionChildren(@Nonnull Projection projection, @Nonnull ProjectionElement bootstrappedProjectionElement) {
        for (ProjectionChild projectionChild : projection.getChildren()) {
            this.handleElementProjection((cool.klass.model.meta.domain.api.projection.ProjectionElement)projectionChild, bootstrappedProjectionElement);
        }
    }

    private void handleElementProjection(@Nonnull cool.klass.model.meta.domain.api.projection.ProjectionElement projectionElement, final @Nonnull ProjectionElement bootstrappedProjectionParent) {
        projectionElement.visit(new ProjectionVisitor(){

            public void visitProjection(@Nonnull Projection projection) {
                throw new AssertionError();
            }

            public void visitProjectionReferenceProperty(@Nonnull cool.klass.model.meta.domain.api.projection.ProjectionReferenceProperty projectionReferenceProperty) {
                ProjectionElement bootstrappedProjectionElement = new ProjectionElement();
                bootstrappedProjectionElement.setName(projectionReferenceProperty.getName());
                bootstrappedProjectionElement.setOrdinal(projectionReferenceProperty.getOrdinal());
                bootstrappedProjectionElement.setParentId(bootstrappedProjectionParent.getId());
                bootstrappedProjectionElement.insert();
                ProjectionWithAssociationEnd bootstrappedProjectionWithAssociationEnd = new ProjectionWithAssociationEnd();
                bootstrappedProjectionWithAssociationEnd.setId(bootstrappedProjectionElement.getId());
                bootstrappedProjectionWithAssociationEnd.setAssociationEndClass(projectionReferenceProperty.getProperty().getOwningClassifier().getName());
                bootstrappedProjectionWithAssociationEnd.setAssociationEndName(projectionReferenceProperty.getProperty().getName());
                bootstrappedProjectionWithAssociationEnd.insert();
                ProjectionReferenceProperty bootstrappedProjectionReferenceProperty = new ProjectionReferenceProperty();
                bootstrappedProjectionReferenceProperty.setId(bootstrappedProjectionElement.getId());
                bootstrappedProjectionReferenceProperty.insert();
                for (ProjectionChild projectionChild : projectionReferenceProperty.getChildren()) {
                    KlassBootstrapWriter.this.handleElementProjection((cool.klass.model.meta.domain.api.projection.ProjectionElement)projectionChild, bootstrappedProjectionElement);
                }
            }

            public void visitProjectionProjectionReference(@Nonnull ProjectionProjectionReference projectionProjectionReference) {
                ProjectionElement bootstrappedProjectionElement = new ProjectionElement();
                bootstrappedProjectionElement.setName(projectionProjectionReference.getName());
                bootstrappedProjectionElement.setOrdinal(projectionProjectionReference.getOrdinal());
                bootstrappedProjectionElement.setParentId(bootstrappedProjectionParent.getId());
                bootstrappedProjectionElement.insert();
                ProjectionWithAssociationEnd bootstrappedProjectionWithAssociationEnd = new ProjectionWithAssociationEnd();
                bootstrappedProjectionWithAssociationEnd.setId(bootstrappedProjectionElement.getId());
                bootstrappedProjectionWithAssociationEnd.setAssociationEndClass(projectionProjectionReference.getProperty().getOwningClassifier().getName());
                bootstrappedProjectionWithAssociationEnd.setAssociationEndName(projectionProjectionReference.getProperty().getName());
                bootstrappedProjectionWithAssociationEnd.insert();
                klass.model.meta.domain.ProjectionProjectionReference bootstrappedProjectionProjectionReference = new klass.model.meta.domain.ProjectionProjectionReference();
                bootstrappedProjectionProjectionReference.setId(bootstrappedProjectionElement.getId());
                bootstrappedProjectionProjectionReference.setProjectionName(projectionProjectionReference.getProjection().getName());
                bootstrappedProjectionProjectionReference.insert();
            }

            public void visitProjectionDataTypeProperty(@Nonnull ProjectionDataTypeProperty projectionDataTypeProperty) {
                ProjectionElement bootstrappedProjectionElement = new ProjectionElement();
                bootstrappedProjectionElement.setName(projectionDataTypeProperty.getName());
                bootstrappedProjectionElement.setOrdinal(projectionDataTypeProperty.getOrdinal());
                bootstrappedProjectionElement.setParentId(bootstrappedProjectionParent.getId());
                bootstrappedProjectionElement.insert();
                klass.model.meta.domain.ProjectionDataTypeProperty bootstrappedProjectionDataTypeProperty = new klass.model.meta.domain.ProjectionDataTypeProperty();
                bootstrappedProjectionDataTypeProperty.setId(bootstrappedProjectionElement.getId());
                bootstrappedProjectionDataTypeProperty.setPropertyClassifierName(projectionDataTypeProperty.getProperty().getOwningClassifier().getName());
                bootstrappedProjectionDataTypeProperty.setPropertyName(projectionDataTypeProperty.getProperty().getName());
                bootstrappedProjectionDataTypeProperty.insert();
            }
        });
    }

    private NamedProjection handleNamedProjection(@Nonnull Projection projection, @Nonnull MutableMap<Projection, ProjectionElement> rootProjectionByProjection) {
        ProjectionElement bootstrappedRootProjection = (ProjectionElement)rootProjectionByProjection.get((Object)projection);
        NamedProjection bootstrappedProjection = new NamedProjection();
        bootstrappedProjection.setName(projection.getName());
        bootstrappedProjection.setProjectionId(bootstrappedRootProjection.getId());
        return bootstrappedProjection;
    }

    private klass.model.meta.domain.ServiceGroup handleServiceGroup(@Nonnull ServiceGroup serviceGroup) {
        klass.model.meta.domain.ServiceGroup bootstrappedServiceGroup = new klass.model.meta.domain.ServiceGroup();
        bootstrappedServiceGroup.setName(serviceGroup.getName());
        bootstrappedServiceGroup.setClassName(serviceGroup.getKlass().getName());
        return bootstrappedServiceGroup;
    }

    private klass.model.meta.domain.Url handleUrl(@Nonnull Url url) {
        ServiceGroup serviceGroup = url.getServiceGroup();
        klass.model.meta.domain.Url bootstrappedUrl = new klass.model.meta.domain.Url();
        bootstrappedUrl.setServiceGroupName(serviceGroup.getName());
        bootstrappedUrl.setUrl(url.getUrlString());
        return bootstrappedUrl;
    }

    private UrlParameter handleUrlParameter(Url url, @Nonnull cool.klass.model.meta.domain.api.parameter.Parameter parameter, String urlParameterType, @Nonnull MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter> bootstrappedParametersByParameter) {
        Parameter bootstrappedParameter = new Parameter();
        KlassBootstrapWriter.handleNamedElement((NamedElementAbstract)bootstrappedParameter, (NamedElement)parameter);
        bootstrappedParameter.setMultiplicity(parameter.getMultiplicity().getPrettyName());
        bootstrappedParameter.insert();
        DataType dataType = parameter.getType();
        if (dataType instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)dataType;
            PrimitiveParameter bootstrappedPrimitiveParameter = new PrimitiveParameter();
            bootstrappedPrimitiveParameter.setPrimitiveType(primitiveType.getPrettyName());
            bootstrappedPrimitiveParameter.setId(bootstrappedParameter.getId());
        } else if (dataType instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)dataType;
            EnumerationParameter bootstrappedEnumerationParameter = new EnumerationParameter();
            bootstrappedEnumerationParameter.setEnumerationName(enumeration.getName());
            bootstrappedEnumerationParameter.setId(bootstrappedParameter.getId());
        } else {
            throw new AssertionError();
        }
        UrlParameter bootstrappedUrlParameter = new UrlParameter();
        bootstrappedUrlParameter.setParameter(bootstrappedParameter);
        bootstrappedUrlParameter.setServiceGroupName(url.getServiceGroup().getName());
        bootstrappedUrlParameter.setUrlString(url.getUrlString());
        bootstrappedUrlParameter.setType(urlParameterType);
        bootstrappedParametersByParameter.put((Object)parameter, (Object)bootstrappedParameter);
        return bootstrappedUrlParameter;
    }

    private PrimitiveParameter handleUrlPrimitiveParameter(@Nonnull cool.klass.model.meta.domain.api.parameter.Parameter parameter, @Nonnull MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter> bootstrappedParametersByParameter) {
        Parameter bootstrappedParameter = (Parameter)bootstrappedParametersByParameter.get((Object)parameter);
        PrimitiveType primitiveType = (PrimitiveType)parameter.getType();
        PrimitiveParameter bootstrappedPrimitiveParameter = new PrimitiveParameter();
        bootstrappedPrimitiveParameter.setPrimitiveType(primitiveType.getPrettyName());
        bootstrappedPrimitiveParameter.setId(bootstrappedParameter.getId());
        return bootstrappedPrimitiveParameter;
    }

    private EnumerationParameter handleUrlEnumerationParameter(@Nonnull cool.klass.model.meta.domain.api.parameter.Parameter parameter, @Nonnull MutableMap<cool.klass.model.meta.domain.api.parameter.Parameter, Parameter> bootstrappedParametersByParameter) {
        Parameter bootstrappedParameter = (Parameter)bootstrappedParametersByParameter.get((Object)parameter);
        Enumeration enumeration = (Enumeration)parameter.getType();
        EnumerationParameter bootstrappedEnumerationParameter = new EnumerationParameter();
        bootstrappedEnumerationParameter.setEnumerationName(enumeration.getName());
        bootstrappedEnumerationParameter.setId(bootstrappedParameter.getId());
        return bootstrappedEnumerationParameter;
    }

    private klass.model.meta.domain.Service handleService(@Nonnull Service service, @Nonnull ImmutableMap<cool.klass.model.meta.domain.api.criteria.Criteria, Criteria> criteriaByCriteria) {
        Url url = service.getUrl();
        ServiceGroup serviceGroup = url.getServiceGroup();
        klass.model.meta.domain.Service bootstrappedService = new klass.model.meta.domain.Service();
        bootstrappedService.setServiceGroupName(serviceGroup.getName());
        bootstrappedService.setUrlString(url.getUrlString());
        bootstrappedService.setVerb(service.getVerb().name());
        bootstrappedService.setServiceMultiplicity(service.getServiceMultiplicity().getPrettyName());
        service.getProjectionDispatch().map(ServiceProjectionDispatch::getProjection).map(NamedElement::getName).ifPresent(arg_0 -> ((klass.model.meta.domain.Service)bootstrappedService).setProjectionName(arg_0));
        service.getQueryCriteria().ifPresent(criteria -> {
            Criteria queryCriteria = (Criteria)criteriaByCriteria.get(criteria);
            Objects.requireNonNull(queryCriteria, "queryCriteria");
            bootstrappedService.setQueryCriteriaId(queryCriteria.getId());
        });
        return bootstrappedService;
    }

    @Nonnull
    private ThisMemberReferencePath bootstrapThisMemberReferencePath(@Nonnull cool.klass.model.meta.domain.api.value.ThisMemberReferencePath thisMemberReferencePath) {
        ExpressionValue bootstrappedExpressionValue = new ExpressionValue();
        bootstrappedExpressionValue.insert();
        cool.klass.model.meta.domain.api.Klass klass = thisMemberReferencePath.getKlass();
        cool.klass.model.meta.domain.api.property.DataTypeProperty property = thisMemberReferencePath.getProperty();
        MemberReferencePath bootstrappedMemberReferencePath = new MemberReferencePath();
        bootstrappedMemberReferencePath.setId(bootstrappedExpressionValue.getId());
        bootstrappedMemberReferencePath.setClassName(klass.getName());
        bootstrappedMemberReferencePath.setPropertyClassName(property.getOwningClassifier().getName());
        bootstrappedMemberReferencePath.setPropertyName(property.getName());
        ThisMemberReferencePath bootstrappedThisMemberReferencePath = new ThisMemberReferencePath();
        bootstrappedThisMemberReferencePath.setId(bootstrappedExpressionValue.getId());
        if (thisMemberReferencePath.getAssociationEnds().notEmpty()) {
            throw new AssertionError((Object)"TODO");
        }
        return bootstrappedThisMemberReferencePath;
    }

    public static void handleNamedElement(@Nonnull NamedElementAbstract bootstrappedNamedElement, @Nonnull NamedElement namedElement) {
        bootstrappedNamedElement.setName(namedElement.getName());
        bootstrappedNamedElement.setOrdinal(namedElement.getOrdinal());
    }
}

