/*
 * Copyright 2024 Craig Motlin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cool.klass.dropwizard.bundle.graphql;

import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.GraphQLHttpServlet;

public class ConfiguredGraphQLHttpServlet
        extends GraphQLHttpServlet
{
    private final GraphQLConfiguration config;

    public ConfiguredGraphQLHttpServlet(GraphQLConfiguration config)
    {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    protected GraphQLConfiguration getConfiguration()
    {
        return this.config;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
    {
        super.doGet(req, resp);
    }
}
