/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.bundle.graphql;

import com.gs.fw.common.mithra.MithraList;
import com.gs.fw.common.mithra.finder.AbstractRelatedFinder;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.common.mithra.finder.orderby.OrderBy;
import com.gs.fw.finder.DomainList;
import com.gs.fw.finder.Operation;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.converter.graphql.ReladomoTreeGraphqlConverter;
import cool.klass.reladomo.tree.deep.fetcher.ReladomoTreeNodeDeepFetcherListener;
import cool.klass.reladomo.tree.serializer.ReladomoTreeObjectToDTOSerializerListener;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import io.liftwizard.graphql.exception.LiftwizardGraphQLException;
import io.liftwizard.reladomo.graphql.operation.GraphQLQueryToOperationConverter;
import io.liftwizard.reladomo.graphql.operation.LiftwizardGraphQLContextException;
import io.liftwizard.reladomo.graphql.orderby.GraphQLQueryToOrderByConverter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ByFinderDataFetcher
implements DataFetcher<Object> {
    private final Klass klass;
    private final ReladomoDataStore dataStore;
    private final ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter;
    private final RelatedFinder<?> finder;

    public ByFinderDataFetcher(Klass klass, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        this.klass = Objects.requireNonNull(klass);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.reladomoTreeGraphqlConverter = Objects.requireNonNull(reladomoTreeGraphqlConverter);
        this.finder = this.dataStore.getRelatedFinder((Classifier)klass);
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        Map arguments = environment.getArguments();
        Object inputOperation = arguments.get("operation");
        com.gs.fw.common.mithra.finder.Operation operation = this.getOperation((Map)inputOperation);
        Object inputOrderBy = arguments.get("orderBy");
        Optional<OrderBy> orderBys = this.getOrderBys((List)inputOrderBy);
        MithraList result = this.finder.findMany((Operation)operation);
        orderBys.ifPresent(arg_0 -> ((MithraList)result).setOrderBy(arg_0));
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        RootReladomoTreeNode rootReladomoTreeNode = this.reladomoTreeGraphqlConverter.convert(this.klass, selectionSet);
        ReladomoTreeNodeDeepFetcherListener deepFetcherListener = new ReladomoTreeNodeDeepFetcherListener(this.dataStore, (DomainList)result, this.klass);
        rootReladomoTreeNode.walk((ReladomoTreeNodeListener)deepFetcherListener);
        ReladomoTreeObjectToDTOSerializerListener serializerVisitor = new ReladomoTreeObjectToDTOSerializerListener(this.dataStore, (DomainList)result, this.klass);
        rootReladomoTreeNode.toManyAwareWalk((ReladomoTreeNodeToManyAwareListener)serializerVisitor);
        return serializerVisitor.getResult();
    }

    public com.gs.fw.common.mithra.finder.Operation getOperation(Map<?, ?> inputOperation) {
        try {
            GraphQLQueryToOperationConverter converter = new GraphQLQueryToOperationConverter();
            return converter.convert((AbstractRelatedFinder)this.finder, inputOperation);
        }
        catch (LiftwizardGraphQLContextException e) {
            throw new LiftwizardGraphQLException(e.getMessage(), e.getContext(), (RuntimeException)((Object)e));
        }
    }

    public Optional<OrderBy> getOrderBys(List<Map<String, ?>> inputOrderBy) {
        try {
            return GraphQLQueryToOrderByConverter.convertOrderByList(this.finder, inputOrderBy);
        }
        catch (LiftwizardGraphQLContextException e) {
            throw new LiftwizardGraphQLException(e.getMessage(), e.getContext(), (RuntimeException)((Object)e));
        }
    }
}

