/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.bundle.graphql;

import com.gs.fw.finder.DomainList;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.converter.graphql.ReladomoTreeGraphqlConverter;
import cool.klass.reladomo.tree.deep.fetcher.ReladomoTreeNodeDeepFetcherListener;
import cool.klass.reladomo.tree.serializer.ReladomoTreeObjectToDTOSerializerListener;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;

public class ByKeyDataFetcher
implements DataFetcher<Object> {
    private final Klass klass;
    private final ReladomoDataStore dataStore;
    private final ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter;

    public ByKeyDataFetcher(Klass klass, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        this.klass = Objects.requireNonNull(klass);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.reladomoTreeGraphqlConverter = Objects.requireNonNull(reladomoTreeGraphqlConverter);
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        MutableMap keys = this.klass.getKeyProperties().tap((Procedure & Serializable)keyProperty -> this.assertEnvironmentContains(environment, (DataTypeProperty)keyProperty)).toMap((Function & Serializable)each -> each, (Function & Serializable)keyProperty -> environment.getArgument(keyProperty.getName()));
        List result = this.dataStore.findByKeyReturningList(this.klass, (MapIterable)keys);
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        RootReladomoTreeNode rootReladomoTreeNode = this.reladomoTreeGraphqlConverter.convert(this.klass, selectionSet);
        ReladomoTreeNodeDeepFetcherListener deepFetcherListener = new ReladomoTreeNodeDeepFetcherListener(this.dataStore, (DomainList)result, this.klass);
        rootReladomoTreeNode.walk((ReladomoTreeNodeListener)deepFetcherListener);
        ReladomoTreeObjectToDTOSerializerListener serializerVisitor = new ReladomoTreeObjectToDTOSerializerListener(this.dataStore, (DomainList)result, this.klass);
        rootReladomoTreeNode.toManyAwareWalk((ReladomoTreeNodeToManyAwareListener)serializerVisitor);
        MutableList resultList = serializerVisitor.getResult();
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() > 1) {
            throw new IllegalStateException("Expected 1 result, but got " + resultList.size());
        }
        return resultList.getOnly();
    }

    private void assertEnvironmentContains(DataFetchingEnvironment environment, DataTypeProperty keyProperty) {
        if (environment.containsArgument(keyProperty.getName())) {
            return;
        }
        String detailMessage = "Argument " + keyProperty.getName() + " is required for " + this.klass.getName();
        throw new IllegalArgumentException(detailMessage);
    }
}

