/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.bundle.graphql;

import com.gs.fw.finder.DomainList;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.converter.graphql.ReladomoTreeGraphqlConverter;
import cool.klass.reladomo.tree.deep.fetcher.ReladomoTreeNodeDeepFetcherListener;
import cool.klass.reladomo.tree.serializer.ReladomoTreeObjectToDTOSerializerListener;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.list.MutableList;

public class AllDataFetcher
implements DataFetcher<Object> {
    private final Klass klass;
    private final ReladomoDataStore dataStore;
    private final ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter;

    public AllDataFetcher(Klass klass, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        this.klass = Objects.requireNonNull(klass);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.reladomoTreeGraphqlConverter = Objects.requireNonNull(reladomoTreeGraphqlConverter);
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        List data = this.dataStore.findAll(this.klass);
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        RootReladomoTreeNode rootReladomoTreeNode = this.reladomoTreeGraphqlConverter.convert(this.klass, selectionSet);
        ReladomoTreeNodeDeepFetcherListener deepFetcherListener = new ReladomoTreeNodeDeepFetcherListener(this.dataStore, (DomainList)data, this.klass);
        rootReladomoTreeNode.walk((ReladomoTreeNodeListener)deepFetcherListener);
        ReladomoTreeObjectToDTOSerializerListener serializerVisitor = new ReladomoTreeObjectToDTOSerializerListener(this.dataStore, (DomainList)data, this.klass);
        rootReladomoTreeNode.toManyAwareWalk((ReladomoTreeNodeToManyAwareListener)serializerVisitor);
        MutableList result = serializerVisitor.getResult();
        return result;
    }
}

